/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.resources.css.CommonCSS;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public class ExtendedPagedTable<T extends GenericSummary>
extends PagedTable<T> {
    private final CommonCSS commonCSS = CommonResources.INSTANCE.css();
    private List<Column<T, ?>> ignoreSelectionColumns = new ArrayList();
    private int selectedRow = -1;
    private BiConsumer<T, Boolean> selectionCallback = null;

    public ExtendedPagedTable(GridGlobalPreferences gridPreferences) {
        super(10, item -> item == null ? null : item.getId(), gridPreferences, true);
        this.dataGrid.addColumnSortHandler((ColumnSortEvent.Handler)new ColumnSortEvent.AsyncHandler((HasData)this.dataGrid));
        this.setSelectionModel((SelectionModel)this.createSelectionModel(), (CellPreviewEvent.Handler)this.createNoActionColumnManager());
        this.setRowStyles((row, rowIndex) -> {
            if (rowIndex == this.selectedRow) {
                return this.commonCSS.selected();
            }
            return null;
        });
    }

    public void setTooltip(int row, int column, String description) {
        ((TableCellElement)this.dataGrid.getRowElement(row).getCells().getItem(column)).setTitle(description);
    }

    public int getKeyboardSelectedColumn() {
        return this.dataGrid.getKeyboardSelectedColumn();
    }

    public int getKeyboardSelectedRow() {
        return this.dataGrid.getKeyboardSelectedRow();
    }

    public int getColumnCount() {
        return this.dataGrid.getColumnCount();
    }

    public void removeColumn(Column<T, ?> col) {
        this.dataGrid.removeColumn(col);
    }

    public void removeColumnMeta(ColumnMeta<T> columnMeta) {
        this.columnPicker.removeColumn(columnMeta);
    }

    public Collection<ColumnMeta<T>> getColumnMetaList() {
        return this.columnPicker.getColumnMetaList();
    }

    public void addSelectionIgnoreColumn(Column<T, ?> column) {
        if (!this.ignoreSelectionColumns.contains(column)) {
            this.ignoreSelectionColumns.add(column);
        }
    }

    public boolean removeSelectionIgnoreColumn(Column<T, ?> column) {
        return this.ignoreSelectionColumns.remove(column);
    }

    public boolean isSelectionIgnoreColumn(int colIx) {
        return colIx >= 0 && this.ignoreSelectionColumns.stream().anyMatch(col -> this.getColumnIndex((Column)col) == colIx);
    }

    public List<T> getSelectedItems() {
        return StreamSupport.stream(this.getVisibleItems().spliterator(), false).filter(domain -> domain.isSelected()).collect(Collectors.toList());
    }

    public boolean hasSelectedItems() {
        return StreamSupport.stream(this.getVisibleItems().spliterator(), false).anyMatch(domain -> domain.isSelected());
    }

    public void deselectAllItems() {
        this.getVisibleItems().forEach(pis -> pis.setSelected(false));
    }

    public boolean isAllItemsSelected() {
        if (this.getVisibleItemCount() == 0) {
            return false;
        }
        return StreamSupport.stream(this.getVisibleItems().spliterator(), false).allMatch(pis -> pis.isSelected());
    }

    protected NoSelectionModel<T> createSelectionModel() {
        NoSelectionModel selectionModel = new NoSelectionModel();
        ExtendedPagedTable extendedPagedTable = this;
        selectionModel.addSelectionChangeHandler(event -> {
            boolean close = false;
            if (this.selectedRow == -1 || extendedPagedTable.getKeyboardSelectedRow() != this.selectedRow) {
                this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                extendedPagedTable.redraw();
            } else {
                close = true;
            }
            if (this.selectionCallback != null) {
                this.selectionCallback.accept(selectionModel.getLastSelectedObject(), close);
            }
        });
        return selectionModel;
    }

    protected DefaultSelectionEventManager<T> createNoActionColumnManager() {
        final ExtendedPagedTable extendedPagedTable = this;
        return DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<T>(){

            public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
                DefaultSelectionEventManager.SelectAction ret = DefaultSelectionEventManager.SelectAction.DEFAULT;
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    Element target;
                    if (extendedPagedTable.isSelectionIgnoreColumn(event.getColumn())) {
                        ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    if ("input".equals((target = (Element)nativeEvent.getEventTarget().cast()).getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        GenericSummary domain = (GenericSummary)event.getValue();
                        if (domain.isSelected()) {
                            input.setChecked(false);
                            domain.setSelected(false);
                        } else {
                            input.setChecked(true);
                            domain.setSelected(true);
                        }
                        extendedPagedTable.redraw();
                        ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return ret;
            }
        });
    }

    public void setSelectionCallback(BiConsumer<T, Boolean> selectionCallback) {
        this.selectionCallback = selectionCallback;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }
}

