/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.advanced;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.jbpm.workbench.common.client.filters.advanced.AdvancedFiltersPresenter;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.df.client.filter.AdvancedFilterEditor;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdvancedFiltersPresenterTest {
    @Mock
    AdvancedFilterEditor advancedFilterEditorView;
    @Mock
    FilterSettingsManager filterSettingsManager;
    @Mock
    FilterSettings filterSettingsMock;
    @Mock
    PlaceManager placeManagerMock;
    @Mock
    EventSourceMock<SavedFilterSelectedEvent> savedFilterEvent;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    AdvancedFiltersPresenter presenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.filterSettingsManager.createFilterSettingsPrototype()).thenReturn((Object)this.filterSettingsMock);
        ((EventSourceMock)Mockito.doNothing().when(this.savedFilterEvent)).fire(Matchers.any());
        ((EventSourceMock)Mockito.doNothing().when(this.notificationEvent)).fire(Matchers.any());
        this.presenter = (AdvancedFiltersPresenter)Mockito.spy(AdvancedFiltersPresenter.class);
        this.presenter.setFilterSettingsManager(this.filterSettingsManager);
        this.presenter.setAdvancedFilterEditorView(this.advancedFilterEditorView);
        this.presenter.setSavedFilterSelectedEvent(this.savedFilterEvent);
        this.presenter.setNotificationEvent(this.notificationEvent);
        this.presenter.setPlaceManager(this.placeManagerMock);
    }

    @Test
    public void testSuccessfulSaveAdvancedFilters() {
        this.presenter.onOpen();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Consumer.class);
        ((AdvancedFilterEditor)Mockito.verify((Object)this.advancedFilterEditorView)).init((FilterSettings)Matchers.any(), (Consumer)captor.capture());
        FilterSettings filterSettings = new FilterSettings();
        ((Consumer)captor.getValue()).accept(filterSettings);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Consumer.class);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).saveFilterIntoPreferences((FilterSettings)Matchers.eq((Object)filterSettings), (Consumer)captor2.capture());
        ((Consumer)captor2.getValue()).accept(true);
        ((EventSourceMock)Mockito.verify(this.savedFilterEvent)).fire(Matchers.any());
    }

    @Test
    public void testUnsuccessfulSaveAdvancedFilters() {
        this.presenter.onOpen();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Consumer.class);
        ((AdvancedFilterEditor)Mockito.verify((Object)this.advancedFilterEditorView)).init((FilterSettings)Matchers.any(), (Consumer)captor.capture());
        FilterSettings filterSettings = new FilterSettings();
        ((Consumer)captor.getValue()).accept(filterSettings);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Consumer.class);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).saveFilterIntoPreferences((FilterSettings)Matchers.eq((Object)filterSettings), (Consumer)captor2.capture());
        ((Consumer)captor2.getValue()).accept(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.savedFilterEvent});
        ((AdvancedFilterEditor)Mockito.verify((Object)this.advancedFilterEditorView)).setTableNameError(Mockito.anyString());
    }
}

