/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.saved;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.function.Consumer;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterAsDefaultActiveEvent;
import org.jbpm.workbench.common.client.filters.saved.SavedFiltersPresenter;
import org.jbpm.workbench.common.client.filters.saved.SavedFiltersViewImpl;
import org.jbpm.workbench.df.client.events.SavedFilterAddedEvent;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SavedFiltersPresenterTest {
    @Mock
    FilterSettingsManager filterSettingsManager;
    @Mock
    SavedFiltersViewImpl view;
    @Spy
    @InjectMocks
    SavedFiltersPresenter presenter;

    @Test
    public void testLoadSavedFilters() {
        SavedFilter filter = new SavedFilter("key", "name");
        ((FilterSettingsManager)Mockito.doAnswer(invocation -> {
            Consumer filters = (Consumer)invocation.getArguments()[0];
            filters.accept(Collections.singletonList(filter));
            return null;
        }).when((Object)this.filterSettingsManager)).loadSavedFilters((Consumer)Mockito.any());
        this.presenter.loadSavedFilters();
        ((SavedFiltersViewImpl)Mockito.verify((Object)this.view)).addSavedFilter(filter);
    }

    @Test
    public void testRemoveSavedFilters() {
        SavedFilter filter = new SavedFilter("key", "name");
        this.presenter.removeSavedFilter(filter);
        ((SavedFiltersViewImpl)Mockito.verify((Object)this.view)).removeSavedFilter(filter);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).removeSavedFilterFromPreferences(filter.getKey());
    }

    @Test
    public void testOnRestoreFilters() {
        this.presenter.onRestoreFilters();
        ((SavedFiltersViewImpl)Mockito.verify((Object)this.view)).removeAllSavedFilters();
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).resetDefaultSavedFilters((Consumer)Mockito.any());
    }

    @Test
    public void testOnSaveFilter() {
        SavedFilter filter = new SavedFilter("key", "name");
        this.presenter.onSaveFilter(new SavedFilterAddedEvent(filter));
        ((SavedFiltersViewImpl)Mockito.verify((Object)this.view)).addSavedFilter(filter);
    }

    @Test
    public void testMenus() {
        this.presenter.getMenus(menus -> Assert.assertEquals((long)1L, (long)menus.getItems().size()));
    }

    @Test
    public void testOnSaveDefaultActiveFilter() {
        String defaultFilterKey = "filterKey";
        SavedFilter filter = new SavedFilter(defaultFilterKey, "name");
        ((FilterSettingsManager)Mockito.doAnswer(invocation -> {
            Command callback = (Command)invocation.getArguments()[1];
            callback.execute();
            return null;
        }).when((Object)this.filterSettingsManager)).saveDefaultActiveFilter(Mockito.anyString(), (Command)Mockito.any());
        this.presenter.onSaveDefaultActiveFilter(new SavedFilterAsDefaultActiveEvent(filter));
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).saveDefaultActiveFilter((String)Mockito.eq((Object)filter.getKey()), (Command)Mockito.any());
        ((SavedFiltersViewImpl)Mockito.verify((Object)this.view)).updateSavedFiltersDefault(defaultFilterKey);
    }
}

