/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilters;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.BlockingError;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.GridSortedColumnPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractMultiGridPresenter>
extends Composite
implements MultiGridView<T, V>,
RequiresResize {
    public static final String COL_ID_SELECT = "Select";
    public static final String COL_ID_ACTIONS = "Actions";
    public static final int ACTIONS_COLUMN_WIDTH = 175;
    public static final int CHECK_COLUMN_WIDTH = 38;
    public static final int ERROR_COLUMN_WIDTH = 65;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected ManagePreferences preferences;
    protected Caller<UserPreferencesService> userPreferencesService;
    protected ListTable<T> listTable;
    protected V presenter;
    @Inject
    @DataField(value="column")
    protected HTMLDivElement column;
    @Inject
    @DataField(value="active-filters")
    protected ActiveFilters filters;
    @Inject
    @DataField(value="alert")
    protected BlockingError alert;

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void displayBlockingError(String summary, String content) {
        this.column.classList.add(new String[]{"hidden"});
        this.filters.getElement().classList.add(new String[]{"hidden"});
        this.alert.getElement().classList.remove(new String[]{"hidden"});
        this.alert.setSummary(summary);
        this.alert.setDescription(content);
    }

    @Override
    public void clearBlockingError() {
        this.filters.getElement().classList.remove(new String[]{"hidden"});
        this.alert.getElement().classList.add(new String[]{"hidden"});
        this.alert.setSummary("");
        this.alert.setDescription("");
        this.column.classList.remove(new String[]{"hidden"});
    }

    public void init(V presenter) {
        this.presenter = presenter;
    }

    protected void controlBulkOperations(ListTable<T> extendedPagedTable) {
        this.enableWidgets(StreamSupport.stream(extendedPagedTable.getRightActionsToolbar().spliterator(), false).findFirst().orElse(null), extendedPagedTable.hasSelectedItems());
    }

    protected void enableWidgets(Widget widget, boolean enable) {
        if (widget == null) {
            return;
        }
        if (widget instanceof HasEnabled) {
            ((HasEnabled)widget).setEnabled(enable);
        }
        if (widget instanceof HasWidgets) {
            for (Widget w : (HasWidgets)widget) {
                this.enableWidgets(w, enable);
            }
        }
    }

    @Override
    public void loadListTable(String key, Consumer<ListTable<T>> readyCallback) {
        this.preferences.load(preferences -> {
            GridGlobalPreferences pref = new GridGlobalPreferences(key, this.getInitColumns(), this.getBannedColumns());
            pref.setPageSize(preferences.getItemsPerPage().intValue());
            ListTable newListGrid = new ListTable(pref);
            newListGrid.setShowLastPagerButton(false);
            newListGrid.setShowFastFordwardPagerButton(false);
            newListGrid.enableDataGridMinWidth(true);
            this.initSelectionModel(newListGrid);
            this.addColumnSortHandler(newListGrid);
            ((UserPreferencesService)this.userPreferencesService.call(preferencesStore -> {
                if (preferencesStore == null) {
                    newListGrid.setGridPreferencesStore(new GridPreferencesStore(pref));
                } else {
                    newListGrid.setGridPreferencesStore((GridPreferencesStore)preferencesStore);
                }
                this.initColumns(newListGrid);
                newListGrid.loadPageSizePreferences();
                newListGrid.setPreferencesService(this.userPreferencesService);
                this.addNewTableToColumn(newListGrid);
                this.listTable = newListGrid;
                readyCallback.accept(this.listTable);
            })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
        }, error -> new DefaultWorkbenchErrorCallback().error(error));
    }

    protected void addColumnSortHandler(ExtendedPagedTable listTable) {
        listTable.addColumnSortHandler(event -> {
            ColumnSortList.ColumnSortInfo columnSortInfo;
            GridPreferencesStore gridPreferencesStore = listTable.getGridPreferencesStore();
            if (gridPreferencesStore != null && event.getColumnSortList().size() > 0 && (columnSortInfo = event.getColumnSortList().get(0)) != null) {
                GridSortedColumnPreference gridSortedColumnPreference = new GridSortedColumnPreference(columnSortInfo.getColumn().getDataStoreName(), columnSortInfo.isAscending());
                gridPreferencesStore.setGridSortedColumnPreference(gridSortedColumnPreference);
            }
            listTable.saveGridPreferences();
        });
    }

    protected void addNewTableToColumn(ListTable<T> newListGrid) {
        if (this.column.childNodes.length == 1.0) {
            this.column.removeChild(this.column.firstChild);
        }
        new Elemental2DomUtil().appendWidgetToElement((HTMLElement)this.column, newListGrid);
    }

    protected Column initGenericColumn(String key) {
        return null;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public ListTable<T> getListGrid() {
        return this.listTable;
    }

    public abstract void initColumns(ListTable<T> var1);

    public void initSelectionModel(ListTable<T> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.getEmptyTableCaption());
        extendedPagedTable.setSelectionCallback(s -> ((AbstractMultiGridPresenter)this.presenter).selectSummaryItem((GenericSummary)s));
        this.initBulkActions(extendedPagedTable);
    }

    public abstract String getEmptyTableCaption();

    public abstract List<String> getInitColumns();

    public abstract List<String> getBannedColumns();

    @Inject
    public void setUserPreferencesService(Caller<UserPreferencesService> userPreferencesService) {
        this.userPreferencesService = userPreferencesService;
    }

    public Column<T, String> createTextColumn(String columnId, final Function<T, String> valueFunction) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return (String)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    protected void initBulkActions(ExtendedPagedTable<T> extendedPagedTable) {
        extendedPagedTable.getRightActionsToolbar().clear();
        ButtonGroup bulkActions = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button bulkButton = (Button)GWT.create(Button.class);
        bulkButton.setText(Constants.INSTANCE.Bulk_Actions());
        bulkButton.setDataToggle(Toggle.DROPDOWN);
        bulkButton.setEnabled(false);
        bulkButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkActions.add((Widget)bulkButton);
        DropDownMenu bulkDropDown = (DropDownMenu)GWT.create(DropDownMenu.class);
        bulkDropDown.addStyleName("dropdown-menu-right");
        bulkDropDown.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        for (AnchorListItem item : this.getBulkActionsItems(extendedPagedTable)) {
            bulkDropDown.add((Widget)item);
        }
        bulkActions.add((Widget)bulkDropDown);
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
    }

    protected List<AnchorListItem> getBulkActionsItems(ExtendedPagedTable<T> extendedPagedTable) {
        return Collections.emptyList();
    }

    public Column<T, Number> createNumberColumn(String columnId, final Function<T, Number> valueFunction) {
        Column column = new Column<T, Number>((Cell)new NumberCell()){

            public Number getValue(T domain) {
                return (Number)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    public ColumnMeta<T> initChecksColumn(final ListTable<T> extendedPagedTable) {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column checkColumn = new Column<T, Boolean>((Cell)checkboxCell){

            public Boolean getValue(T item) {
                return extendedPagedTable.isItemSelected(item);
            }
        };
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName(COL_ID_SELECT);
        checkColumn.setCellStyleNames("kie-datatable-select");
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                return extendedPagedTable.isAllItemsSelected();
            }
        };
        selectPageHeader.setUpdater(value -> {
            if (value.booleanValue()) {
                extendedPagedTable.selectAllItems();
            } else {
                extendedPagedTable.deselectAllItems();
            }
            this.controlBulkOperations(extendedPagedTable);
        });
        selectPageHeader.setHeaderStyleNames("kie-datatable-select");
        checkColumn.setFieldUpdater((index, model, value) -> {
            extendedPagedTable.setItemSelection((T)model, (Boolean)value);
            this.controlBulkOperations(extendedPagedTable);
        });
        ColumnMeta checkColMeta = new ColumnMeta(checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    protected boolean isColumnAdded(List<ColumnMeta<T>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<T> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean existsColumnWithSameName(GridColumnPreference gridColumnPreference, List<ColumnMeta<T>> columns) {
        return columns.stream().filter(meta -> meta.getCaption().equals(gridColumnPreference.getName())).findFirst().isPresent();
    }

    protected abstract List<ConditionalAction<T>> getConditionalActions();

    public ColumnMeta<T> initActionsColumn() {
        ConditionalKebabActionCell cell = (ConditionalKebabActionCell)((Object)this.conditionalKebabActionCell.get());
        cell.setActions(this.getConditionalActions());
        Column actionsColumn = new Column<T, T>((Cell)cell){

            public T getValue(T object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        actionsColumn.setCellStyleNames("kie-table-view-pf-actions text-center");
        TextHeader header = new TextHeader(Constants.INSTANCE.Actions());
        header.setHeaderStyleNames("text-center");
        ColumnMeta actionsColMeta = new ColumnMeta(actionsColumn, "");
        actionsColMeta.setHeader((Header)header);
        actionsColMeta.setVisibleIndex(false);
        return actionsColMeta;
    }

    public List<ColumnMeta<T>> renameVariables(ListTable<T> extendedPagedTable, List<ColumnMeta<T>> columnMetas) {
        List columnPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        return columnPreferenceList.stream().filter(colPref -> !this.isColumnAdded(columnMetas, colPref.getName())).map(colPref -> this.newColumnMeta(colPref.getName(), this.existsColumnWithSameName((GridColumnPreference)colPref, columnMetas), false)).collect(Collectors.toList());
    }

    private ColumnMeta<T> newColumnMeta(String columnName, boolean existsColumnWithSameName, boolean isVisible) {
        Column genericColumn = this.initGenericColumn(columnName);
        genericColumn.setSortable(false);
        String caption = !existsColumnWithSameName ? columnName : "Var_" + columnName;
        return new ColumnMeta(genericColumn, caption, isVisible, true);
    }

    public void addDomainSpecifColumns(Set<String> columns) {
        this.getListGrid().storeColumnToPreferences();
        List<GridColumnPreference> gridColumnPreferenceList = this.removeRedundantColumns(this.getListGrid(), columns);
        List<ColumnMeta<ColumnMeta>> columnMetaList = this.renameDomainSpecifColumns(this.getListGrid(), columns);
        this.addDomainColumns(columnMetaList, columns);
        this.getListGrid().getGridPreferencesStore().getColumnPreferences().addAll(gridColumnPreferenceList);
        columnMetaList.forEach(columnMeta -> {
            List list = gridColumnPreferenceList.stream().filter(gridColumnPreference -> gridColumnPreference.getName().equals(columnMeta.getColumn().getDataStoreName())).collect(Collectors.toList());
            this.getListGrid().getGridPreferencesStore().getColumnPreferences().addAll(list);
            this.getListGrid().addColumns(Arrays.asList(columnMeta));
        });
    }

    private void addDomainColumns(List<ColumnMeta<T>> columnMetaList, Set<String> columns) {
        columns.stream().filter(newColumn -> this.newColumnIsNotInDataStoreNames((String)newColumn, columnMetaList)).forEach(column -> {
            ColumnMeta<T> columnMeta = this.newColumnMeta((String)column, false, false);
            columnMetaList.add(columnMeta);
        });
    }

    private boolean newColumnIsNotInDataStoreNames(String newColumn, List<ColumnMeta<T>> columnMetaList) {
        return columnMetaList.stream().map(colMeta -> colMeta.getColumn().getDataStoreName()).noneMatch(newColumn::contains);
    }

    private List<ColumnMeta<T>> renameDomainSpecifColumns(ExtendedPagedTable<T> extendedPagedTable, Set<String> columns) {
        return extendedPagedTable.getColumnMetaList().stream().filter(cm -> !cm.isExtraColumn() && columns.contains(cm.getCaption())).map(colMet -> this.newColumnMeta(colMet.getCaption(), true, false)).collect(Collectors.toList());
    }

    private List<GridColumnPreference> removeRedundantColumns(ExtendedPagedTable<T> extendedPagedTable, Set<String> columns) {
        List<ColumnMeta> columnMetas = extendedPagedTable.getColumnMetaList().stream().filter(cm -> cm.isExtraColumn()).collect(Collectors.toList());
        ArrayList<GridColumnPreference> gridColumnPreferenceList = new ArrayList<GridColumnPreference>();
        columnMetas.forEach(colMet -> {
            if (!columns.contains(colMet.getCaption())) {
                List columnPreferences = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
                columnPreferences.stream().filter(columnPreference -> columnPreference.getName().equals(colMet.getColumn().getDataStoreName())).forEach(columnPreference -> gridColumnPreferenceList.add((GridColumnPreference)columnPreference));
                extendedPagedTable.removeColumnMeta((ColumnMeta)colMet);
            } else {
                columns.remove(colMet.getCaption());
            }
        });
        return gridColumnPreferenceList;
    }

    public void removeDomainSpecifColumns() {
        ExtendedPagedTable listGrid = this.getListGrid();
        ((UserPreferencesService)this.userPreferencesService.call(arg_0 -> AbstractMultiGridView.lambda$removeDomainSpecifColumns$24((ListTable)listGrid, arg_0))).loadUserPreferences(listGrid.getGridPreferencesStore().getPreferenceKey(), UserPreferencesType.GRIDPREFERENCES);
    }

    @Override
    public void setSaveFilterCallback(BiConsumer<String, Consumer<String>> filterNameCallback) {
        this.filters.setSaveFilterCallback(filterNameCallback);
    }

    @Override
    public <T> void addActiveFilter(ActiveFilterItem<T> filter) {
        this.filters.addActiveFilter(filter);
    }

    @Override
    public <T> void removeActiveFilter(ActiveFilterItem<T> filter) {
        this.filters.removeActiveFilter(filter);
    }

    @Override
    public void removeAllActiveFilters() {
        this.filters.removeAllActiveFilters();
    }

    public void onResize() {
        if (this.listTable != null) {
            this.listTable.onResize();
        }
    }

    @Override
    public ColumnSortList reloadColumnSortList() {
        Optional<ColumnMeta> optional;
        GridSortedColumnPreference gridSortedColumnPreference;
        ColumnSortList columnSortList = this.getListGrid().getColumnSortList();
        GridPreferencesStore gridPreferencesStore = this.getListGrid().getGridPreferencesStore();
        if (gridPreferencesStore != null && (gridSortedColumnPreference = gridPreferencesStore.getGridSortedColumnPreference()) != null && columnSortList.size() <= 1 && (optional = this.getListGrid().getColumnMetaList().stream().filter(tColumnMeta -> tColumnMeta.getColumn().getDataStoreName().equals(gridSortedColumnPreference.getDataStoreName())).findFirst()).isPresent()) {
            Column col = optional.get().getColumn();
            col.setDataStoreName(gridSortedColumnPreference.getDataStoreName());
            columnSortList.push(new ColumnSortList.ColumnSortInfo(col, gridSortedColumnPreference.isAscending()));
        }
        return columnSortList;
    }

    private static /* synthetic */ void lambda$removeDomainSpecifColumns$24(ListTable listGrid, GridPreferencesStore preferencesStore) {
        List<ColumnMeta> metas = listGrid.getColumnMetaList().stream().filter(c -> c.isExtraColumn() && c.isVisible()).collect(Collectors.toList());
        metas.forEach(meta -> {
            listGrid.removeColumnMeta(meta);
            Optional<GridColumnPreference> preference = preferencesStore.getColumnPreferences().stream().filter(pref -> pref.getName().equals(meta.getColumn().getDataStoreName())).findFirst();
            if (preference.isPresent()) {
                preferencesStore.getColumnPreferences().remove(preference.get());
            }
        });
        listGrid.saveGridPreferences();
    }
}

