/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractMultiGridPresenterTest {
    @Mock
    FilterSettingsManager filterSettingsManager;
    @Mock
    FilterSettings filterSettingsMock;
    @Mock
    UberfireBreadcrumbs breadcrumbsMock;
    @Mock
    ListView listView;
    @Mock
    ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilderMock;
    @Mock
    ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView serverTemplateSelectorElementViewMock;
    @Mock
    protected DataSetQueryHelper dataSetQueryHelper;
    @Spy
    Event<ClearAllActiveFiltersEvent> clearAllActiveFiltersEvent = new EventSourceMock();
    @Spy
    AbstractMultiGridPresenter presenter;
    @Mock
    AbstractMultiGridView view;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilderMock.getView()).thenReturn((Object)this.serverTemplateSelectorElementViewMock);
        Mockito.when((Object)this.presenter.getListView()).thenReturn((Object)this.listView);
        this.presenter.setView((MultiGridView)this.view);
        this.presenter.setUberfireBreadcrumbs(this.breadcrumbsMock);
        this.presenter.setServerTemplateSelectorMenuBuilder(this.serverTemplateSelectorMenuBuilderMock);
        this.presenter.setFilterSettingsManager(this.filterSettingsManager);
        this.presenter.setDataSetQueryHelper(this.dataSetQueryHelper);
        this.presenter.setClearAllActiveFiltersEvent(this.clearAllActiveFiltersEvent);
        ((Event)Mockito.doNothing().when(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
    }

    @Test
    public void onOpenActiveSearchTest() {
        Mockito.when((Object)this.presenter.existActiveSearchFilters()).thenReturn((Object)true);
        Mockito.when((Object)this.filterSettingsManager.createDefaultFilterSettingsPrototype()).thenReturn((Object)this.filterSettingsMock);
        Mockito.when((Object)this.filterSettingsMock.getKey()).thenReturn((Object)"key");
        this.presenter.onOpen();
        ArgumentCaptor activeSearchConsumerCaptor = ArgumentCaptor.forClass(Consumer.class);
        ((Event)Mockito.verify(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
        ((AbstractMultiGridView)Mockito.verify((Object)this.view)).loadListTable((String)Matchers.eq((Object)"key"), (Consumer)activeSearchConsumerCaptor.capture());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setCurrentTableSettings(this.filterSettingsMock);
        ((Event)Mockito.verify(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
    }

    @Test
    public void onOpenWithActiveSearchTest() {
        String defaultFilterKey = "defaultFilterKey";
        Mockito.when((Object)this.presenter.existActiveSearchFilters()).thenReturn((Object)false);
        Mockito.when((Object)this.filterSettingsMock.getKey()).thenReturn((Object)defaultFilterKey);
        this.presenter.onOpen();
        ArgumentCaptor defaultFilterConsumerCaptor = ArgumentCaptor.forClass(Consumer.class);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).defaultActiveFilterInit((Consumer)defaultFilterConsumerCaptor.capture());
        ((Consumer)defaultFilterConsumerCaptor.getValue()).accept(this.filterSettingsMock);
        ((AbstractMultiGridView)Mockito.verify((Object)this.view)).removeAllActiveFilters();
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setCurrentTableSettings(this.filterSettingsMock);
        ((AbstractMultiGridView)Mockito.verify((Object)this.view)).loadListTable((String)Matchers.eq((Object)defaultFilterKey), (Consumer)Matchers.any());
    }

    @Test
    public void addActiveFiltersTest() {
        String defaultFilterKey = "defaultFilterKey";
        DataSetLookup dataSetLookupMock = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        DataSetFilter dataSetFilterMock = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        ColumnFilter columnFilter2 = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        AsyncDataProvider dataProviderMock = (AsyncDataProvider)Mockito.mock(AsyncDataProvider.class);
        ListTable listTableMock = (ListTable)Mockito.mock(ListTable.class);
        Mockito.when((Object)this.presenter.existActiveSearchFilters()).thenReturn((Object)false);
        Mockito.when((Object)this.filterSettingsMock.getKey()).thenReturn((Object)defaultFilterKey);
        Mockito.when((Object)this.filterSettingsMock.getDataSetLookup()).thenReturn((Object)dataSetLookupMock);
        Mockito.when((Object)dataSetLookupMock.getFirstFilterOp()).thenReturn((Object)dataSetFilterMock);
        Mockito.when((Object)dataSetFilterMock.getColumnFilterList()).thenReturn(Arrays.asList(columnFilter, columnFilter2));
        this.presenter.setDataProvider(dataProviderMock);
        this.presenter.addActiveFilters(this.filterSettingsMock);
        ((AbstractMultiGridView)Mockito.verify((Object)this.view)).removeAllActiveFilters();
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setCurrentTableSettings(this.filterSettingsMock);
        ArgumentCaptor listTableConsumerCaptor = ArgumentCaptor.forClass(Consumer.class);
        ((AbstractMultiGridView)Mockito.verify((Object)this.view)).loadListTable((String)Matchers.eq((Object)defaultFilterKey), (Consumer)listTableConsumerCaptor.capture());
        ((Consumer)listTableConsumerCaptor.getValue()).accept(listTableMock);
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).getActiveFilterFromColumnFilter(columnFilter);
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).getActiveFilterFromColumnFilter(columnFilter2);
        ((AbstractMultiGridView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addActiveFilter((ActiveFilterItem)Matchers.any(ActiveFilterItem.class));
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).addDataDisplay((HasData)listTableMock);
    }

    @Test
    public void testGetDataNoSorting() {
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettingsMock);
        Mockito.when((Object)this.view.getListGrid()).thenReturn(Mockito.mock(ListTable.class));
        Mockito.when((Object)this.view.getSortColumn()).thenReturn(null);
        Mockito.when((Object)this.view.isSortAscending()).thenReturn(null);
        this.presenter.getData(new Range(0, 10));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.never())).setLastOrderedColumn((String)Matchers.any());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.never())).setLastSortOrder((SortOrder)Matchers.any());
    }

    @Test
    public void testGetDataSorting() {
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettingsMock);
        Mockito.when((Object)this.view.getListGrid()).thenReturn(Mockito.mock(ListTable.class));
        String column = "some_column";
        Mockito.when((Object)this.view.getSortColumn()).thenReturn((Object)"some_column");
        Mockito.when((Object)this.view.isSortAscending()).thenReturn((Object)true);
        this.presenter.getData(new Range(0, 10));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("some_column");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
    }
}

