/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemAddedEvent;
import org.jbpm.workbench.common.client.filters.active.ActiveFiltersImpl;
import org.jbpm.workbench.common.client.filters.active.ActiveFiltersView;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActiveFiltersImplTest {
    @Mock
    ActiveFiltersView view;
    @Spy
    Event<ClearAllActiveFiltersEvent> clearAllActiveFiltersEvent = new EventSourceMock();
    @Spy
    Event<ActiveFilterItemAddedEvent> activeFilterItemAddedEvent = new EventSourceMock();
    @Spy
    Event<NotificationEvent> notificationEvent = new EventSourceMock();
    @InjectMocks
    ActiveFiltersImpl activeFilters;

    @Before
    public void setup() {
        ((Event)Mockito.doNothing().when(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
        ((Event)Mockito.doNothing().when(this.activeFilterItemAddedEvent)).fire(Matchers.any());
        ((Event)Mockito.doNothing().when(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testRemoveAllActiveFilters() {
        this.activeFilters.removeAllActiveFilters();
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).removeAllActiveFilters(Boolean.valueOf(false));
        ((Event)Mockito.verify(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
    }

    @Test
    public void testRemoveAllActiveFiltersCallback() {
        ((ActiveFiltersView)Mockito.doAnswer(invocation -> {
            Command callback = (Command)invocation.getArguments()[0];
            callback.execute();
            return null;
        }).when((Object)this.view)).setRemoveAllFilterCallback((Command)Matchers.any());
        this.activeFilters.init();
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).removeAllActiveFilters(Boolean.valueOf(true));
        ((Event)Mockito.verify(this.clearAllActiveFiltersEvent)).fire(Matchers.any());
    }

    @Test
    public void testAddActiveFilter() {
        ActiveFilterItem filter = new ActiveFilterItem();
        this.activeFilters.addActiveFilter(filter);
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).addActiveFilter(filter);
        ((Event)Mockito.verify(this.activeFilterItemAddedEvent)).fire(Matchers.any());
    }

    @Test
    public void testSaveFilterCallbackNull() {
        ((ActiveFiltersView)Mockito.doAnswer(invocation -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[0];
            callback.execute(null);
            return null;
        }).when((Object)this.view)).setSaveFilterCallback((ParameterizedCommand)Matchers.any());
        this.activeFilters.setSaveFilterCallback((name, callback) -> callback.accept(null));
        this.activeFilters.init();
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).setSaveFilterCallback((ParameterizedCommand)Matchers.any());
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).closeSaveFilter();
        ((ActiveFiltersView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSaveFilterErrorMessage((String)Matchers.any());
    }

    @Test
    public void testSaveFilterCallbackError() {
        String message = "error";
        ((ActiveFiltersView)Mockito.doAnswer(invocation -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[0];
            callback.execute(null);
            return null;
        }).when((Object)this.view)).setSaveFilterCallback((ParameterizedCommand)Matchers.any());
        this.activeFilters.setSaveFilterCallback((name, callback) -> callback.accept("error"));
        this.activeFilters.init();
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).setSaveFilterCallback((ParameterizedCommand)Matchers.any());
        ((ActiveFiltersView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).closeSaveFilter();
        ((ActiveFiltersView)Mockito.verify((Object)this.view)).setSaveFilterErrorMessage("error");
    }
}

