/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.view.client.AsyncDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.GridSortedColumnPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractMultiGridViewTest<T extends GenericSummary> {
    @Mock
    protected AsyncDataProvider dataProviderMock;
    protected CallerMock<UserPreferencesService> userPreferencesService;
    @Mock
    protected UserPreferencesService userPreferencesServiceMock;
    @Mock
    protected ListTable extendedPagedTable;
    @Mock
    protected HasWidgets rightActionsToolbar;
    @Mock
    protected Button mockButton;
    @Spy
    protected GridPreferencesStore gridPreferencesStore;
    @Mock
    protected ManagePreferences preferences;
    @Mock
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;

    protected abstract AbstractMultiGridView getView();

    protected abstract AbstractMultiGridPresenter getPresenter();

    public abstract List<String> getExpectedInitialColumns();

    public abstract List<String> getExpectedBannedColumns();

    public abstract Integer getExpectedNumberOfColumns();

    @Before
    public void setupMocks() {
        this.userPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.getView().setUserPreferencesService(this.userPreferencesService);
        Mockito.when((Object)this.getPresenter().getDataProvider()).thenReturn((Object)this.dataProviderMock);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences((String)Mockito.any(), (UserPreferencesType)Mockito.eq((Object)UserPreferencesType.GRIDPREFERENCES))).thenReturn((Object)new GridPreferencesStore(new GridGlobalPreferences()));
        Mockito.when((Object)this.conditionalKebabActionCell.get()).thenReturn(Mockito.mock(ConditionalKebabActionCell.class));
        ((AbstractMultiGridView)Mockito.doNothing().when((Object)this.getView())).addNewTableToColumn((ListTable)Mockito.any());
        Mockito.when((Object)this.extendedPagedTable.getRightActionsToolbar()).thenReturn((Object)this.rightActionsToolbar);
        List<Button> a = Collections.singletonList(this.mockButton);
        Mockito.when((Object)this.rightActionsToolbar.spliterator()).thenReturn(Spliterators.spliteratorUnknownSize(a.iterator(), 0));
    }

    @Test
    public void selectionIgnoreColumnTest() {
        ExtendedPagedTable extPagedTable = new ExtendedPagedTable(new GridGlobalPreferences());
        Column testCol = this.getView().createTextColumn("testCol", val -> val);
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        Assert.assertTrue((boolean)extPagedTable.removeSelectionIgnoreColumn(testCol));
        extPagedTable.addColumn(testCol, "");
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertTrue((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
    }

    @Test
    public void testInitialColumns() {
        List<String> expectedInitColumns = this.getExpectedInitialColumns();
        Assert.assertEquals((long)expectedInitColumns.size(), (long)this.getView().getInitColumns().size());
        for (int i = 0; i < expectedInitColumns.size(); ++i) {
            Assert.assertEquals((Object)expectedInitColumns.get(i), this.getView().getInitColumns().get(i));
        }
    }

    @Test
    public void testBannedColumns() {
        List bannedColumns = this.getView().getBannedColumns();
        Assert.assertEquals((long)this.getExpectedBannedColumns().size(), (long)bannedColumns.size());
        for (int i = 0; i < bannedColumns.size(); ++i) {
            Assert.assertEquals((Object)this.getExpectedBannedColumns().get(i), bannedColumns.get(i));
        }
    }

    @Test
    public void testDataStoreNameIsSet() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        this.getView().initColumns(currentListGrid);
        ((ListTable)Mockito.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testInitColumns() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == AbstractMultiGridViewTest.this.getExpectedNumberOfColumns().intValue() ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{currentListGrid});
        ((ListTable)inOrder.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
        ((ListTable)inOrder.verify((Object)currentListGrid)).setColumnWidth((Column)Mockito.any(), Mockito.anyDouble(), (Style.Unit)Mockito.any());
    }

    @Test
    public void testInitActionsColumn() {
        ColumnMeta columnMeta = this.getView().initActionsColumn();
        Assert.assertEquals((Object)false, (Object)columnMeta.isVisibleIndex());
    }

    @Test
    public void testGlobalPreferences() {
        ((ManagePreferences)Mockito.doAnswer(inv -> {
            ((ParameterizedCommand)inv.getArguments()[0]).execute((Object)new ManagePreferences().defaultValue(new ManagePreferences()));
            return null;
        }).when((Object)this.preferences)).load((ParameterizedCommand)Mockito.any(ParameterizedCommand.class), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        Consumer<ListTable> consumer = table -> Assert.assertEquals((long)ManagePreferences.DEFAULT_PAGINATION_OPTION.intValue(), (long)table.getGridPreferencesStore().getPageSizePreferences());
        this.getView().loadListTable("key", consumer);
    }

    @Test
    public void testControlBulkOperationsEnabled() {
        Mockito.when((Object)this.extendedPagedTable.hasSelectedItems()).thenReturn((Object)true);
        this.getView().controlBulkOperations(this.extendedPagedTable);
        ((Button)Mockito.verify((Object)this.mockButton)).setEnabled(true);
    }

    @Test
    public void testControlBulkOperationsDisabled() {
        Mockito.when((Object)this.extendedPagedTable.hasSelectedItems()).thenReturn((Object)false);
        this.getView().controlBulkOperations(this.extendedPagedTable);
        ((Button)Mockito.verify((Object)this.mockButton)).setEnabled(false);
    }

    @Test
    public void testEnableDataGridMinWidth() {
        ((ManagePreferences)Mockito.doAnswer(inv -> {
            ((ParameterizedCommand)inv.getArguments()[0]).execute((Object)new ManagePreferences().defaultValue(new ManagePreferences()));
            return null;
        }).when((Object)this.preferences)).load((ParameterizedCommand)Mockito.any(ParameterizedCommand.class), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        Consumer<ListTable> consumer = table -> Assert.assertTrue((boolean)table.isDataGridMinWidthEnabled());
        this.getView().loadListTable("key", consumer);
    }

    public static Column newColumnMock(String dataStoreName) {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getCell()).thenReturn(Mockito.mock(Cell.class));
        Mockito.when((Object)column.getDataStoreName()).thenReturn((Object)dataStoreName);
        return column;
    }

    @Test
    public void testReloadColumnSortListWhenInitListTable() {
        ListTable listTable = (ListTable)Mockito.mock(ListTable.class);
        Mockito.when((Object)this.getView().getListGrid()).thenReturn((Object)listTable);
        GridPreferencesStore gridPreferencesStore = (GridPreferencesStore)Mockito.mock(GridPreferencesStore.class);
        Mockito.when((Object)listTable.getGridPreferencesStore()).thenReturn((Object)gridPreferencesStore);
        GridSortedColumnPreference gridSortedColumnPreference = new GridSortedColumnPreference("test", true);
        Mockito.when((Object)gridPreferencesStore.getGridSortedColumnPreference()).thenReturn((Object)gridSortedColumnPreference);
        ColumnSortList columnSortList = this.getColumnSortList("startDate", null);
        Mockito.when((Object)listTable.getColumnSortList()).thenReturn((Object)columnSortList);
        Mockito.when((Object)listTable.getColumnMetaList()).thenReturn(Arrays.asList(new ColumnMeta(this.getColumn("test"), "test"), new ColumnMeta(this.getColumn("startDate"), "")));
        Assert.assertEquals((long)1L, (long)columnSortList.size());
        this.getView().reloadColumnSortList();
        Assert.assertEquals((long)1L, (long)columnSortList.size());
        Assert.assertEquals((Object)"test", (Object)columnSortList.get(0).getColumn().getDataStoreName());
    }

    private ColumnSortList getColumnSortList(String dataStoreName, ColumnSortList columnSortList) {
        if (columnSortList == null) {
            columnSortList = new ColumnSortList();
        }
        columnSortList.push(new ColumnSortList.ColumnSortInfo(this.getColumn(dataStoreName), true));
        return columnSortList;
    }

    private Column<T, String> getColumn(String name) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return null;
            }
        };
        column.setDataStoreName(name);
        return column;
    }

    @Test
    public void testAddColumnSortHandler() {
        ListTable listTable = (ListTable)Mockito.mock(ListTable.class);
        Mockito.when((Object)listTable.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)listTable.getColumnSortList()).thenReturn((Object)new ColumnSortList());
        ((ListTable)Mockito.doAnswer(invocation -> {
            ColumnSortEvent event = (ColumnSortEvent)Mockito.mock(ColumnSortEvent.class);
            ColumnSortList columnSortList = new ColumnSortList();
            columnSortList.push(this.getColumn("test"));
            Mockito.when((Object)event.getColumnSortList()).thenReturn((Object)columnSortList);
            ((ColumnSortEvent.Handler)invocation.getArguments()[0]).onColumnSort(event);
            return null;
        }).when((Object)listTable)).addColumnSortHandler((ColumnSortEvent.Handler)Mockito.any());
        this.getView().addColumnSortHandler((ExtendedPagedTable)listTable);
        ArgumentCaptor captor = ArgumentCaptor.forClass(GridSortedColumnPreference.class);
        ((GridPreferencesStore)Mockito.verify((Object)this.gridPreferencesStore)).setGridSortedColumnPreference((GridSortedColumnPreference)captor.capture());
        Assert.assertNotNull((Object)captor.getValue());
        Assert.assertEquals((Object)"test", (Object)((GridSortedColumnPreference)captor.getValue()).getDataStoreName());
        Assert.assertEquals((Object)true, (Object)((GridSortedColumnPreference)captor.getValue()).isAscending());
    }

    @Test
    public void testGetSortColumn() {
        ListTable listTable = (ListTable)Mockito.mock(ListTable.class);
        Mockito.when((Object)this.getView().getListGrid()).thenReturn((Object)listTable);
        ColumnSortList columnSortList = new ColumnSortList();
        columnSortList.push(this.getColumn("test"));
        Mockito.when((Object)listTable.getColumnSortList()).thenReturn(null, (Object[])new ColumnSortList[]{null, new ColumnSortList(), new ColumnSortList(), columnSortList, columnSortList});
        Assert.assertNull((Object)this.getView().getSortColumn());
        Assert.assertNull((Object)this.getView().isSortAscending());
        Assert.assertNull((Object)this.getView().getSortColumn());
        Assert.assertNull((Object)this.getView().isSortAscending());
        Assert.assertEquals((Object)"test", (Object)this.getView().getSortColumn());
        Assert.assertEquals((Object)true, (Object)this.getView().isSortAscending());
    }
}

