/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLIElement;
import java.util.Arrays;
import java.util.Collections;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.KebabMenu;
import org.uberfire.client.views.pfly.widgets.KebabMenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConditionalKebabActionCellTest {
    @Mock
    HTMLDocument document;
    @Mock
    ManagedInstance<KebabMenu> kebabMenus;
    @Mock
    ManagedInstance<KebabMenuItem> kebabMenuItems;
    @Mock
    ManagedInstance<Button> buttons;
    @Mock
    KebabMenu kebabMenu;
    @Mock
    Button button;
    @InjectMocks
    ConditionalKebabActionCell kebabActionCell;

    @Before
    public void setup() {
        HTMLDivElement div = (HTMLDivElement)Mockito.mock(HTMLDivElement.class);
        div.innerHTML = "";
        Mockito.when((Object)this.document.createElement("div")).thenReturn((Object)div);
        Mockito.when((Object)this.kebabMenus.get()).thenReturn((Object)this.kebabMenu);
        Mockito.when((Object)this.kebabMenu.getElement()).thenReturn(Mockito.mock(HTMLElement.class));
        KebabMenuItem kebabMenuItem = (KebabMenuItem)Mockito.mock(KebabMenuItem.class);
        Mockito.when((Object)kebabMenuItem.getElement()).thenReturn(Mockito.mock(HTMLLIElement.class));
        Mockito.when((Object)this.kebabMenuItems.get()).thenReturn((Object)kebabMenuItem);
        Mockito.when((Object)this.button.getElement()).thenReturn(Mockito.mock(HTMLElement.class));
        Mockito.when((Object)this.buttons.get()).thenReturn((Object)this.button);
    }

    @Test
    public void testNoActions() {
        this.kebabActionCell.setActions(Collections.emptyList());
        SafeHtmlBuilder htmlBuilder = new SafeHtmlBuilder();
        this.kebabActionCell.render(null, null, htmlBuilder);
        Assert.assertTrue((boolean)htmlBuilder.toSafeHtml().asString().isEmpty());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus, this.document});
    }

    @Test
    public void testNoActionsAvailable() {
        this.kebabActionCell.setActions(Arrays.asList(new ConditionalAction(null, gs -> {}, gs -> false, Boolean.valueOf(true)), new ConditionalAction(null, gs -> {}, gs -> false, Boolean.valueOf(false))));
        SafeHtmlBuilder htmlBuilder = new SafeHtmlBuilder();
        this.kebabActionCell.render(null, null, htmlBuilder);
        Assert.assertTrue((boolean)htmlBuilder.toSafeHtml().asString().isEmpty());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus, this.document});
    }

    @Test
    public void testSingleAction() {
        String label = "label";
        this.kebabActionCell.setActions(Collections.singletonList(new ConditionalAction("label", gs -> {}, gs -> true, Boolean.valueOf(true))));
        this.kebabActionCell.render(null, (GenericSummary)Mockito.mock(GenericSummary.class), new SafeHtmlBuilder());
        ((Button)Mockito.verify((Object)this.button)).setText("label");
        ((ManagedInstance)Mockito.verify(this.buttons)).get();
        ((HTMLDocument)Mockito.verify((Object)this.document)).createElement("div");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.document});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus});
    }

    @Test
    public void testMultipleActions() {
        this.kebabActionCell.setActions(Arrays.asList(new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(true)), new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(false))));
        this.kebabActionCell.render(null, (GenericSummary)Mockito.mock(GenericSummary.class), new SafeHtmlBuilder());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu, (VerificationMode)Mockito.times((int)2))).addKebabItem((HTMLLIElement)Mockito.any());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu)).addSeparator();
    }

    @Test
    public void testMultipleActionsOnly() {
        this.kebabActionCell.setActions(Arrays.asList(new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(false)), new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(false))));
        this.kebabActionCell.render(null, (GenericSummary)Mockito.mock(GenericSummary.class), new SafeHtmlBuilder());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu, (VerificationMode)Mockito.times((int)2))).addKebabItem((HTMLLIElement)Mockito.any());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu, (VerificationMode)Mockito.never())).addSeparator();
    }

    @Test
    public void testMultipleActionsNavigationOnly() {
        this.kebabActionCell.setActions(Arrays.asList(new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(true)), new ConditionalAction(null, gs -> {}, gs -> true, Boolean.valueOf(true))));
        this.kebabActionCell.render(null, (GenericSummary)Mockito.mock(GenericSummary.class), new SafeHtmlBuilder());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu, (VerificationMode)Mockito.times((int)2))).addKebabItem((HTMLLIElement)Mockito.any());
        ((KebabMenu)Mockito.verify((Object)this.kebabMenu, (VerificationMode)Mockito.never())).addSeparator();
    }
}

