/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMock;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetEditorManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

public abstract class AbstractMultiGridViewTest<T extends GenericSummary> {
    protected static final String TEST_KEY = "TEST";
    protected static final String TEST_KEY_GRID1 = "TEST_1";
    protected static final String TEST_KEY_GRID2 = "TEST_2";
    protected static final String TEST_USER_ID = "testUser";
    @GwtMock
    protected FilterPagedTable filterPagedTable;
    @Spy
    protected FilterSettings filterSettings;
    @Mock
    protected DataSetEditorManager dataSetEditorManager;
    @Mock
    protected AsyncDataProvider dataProviderMock;
    protected CallerMock<UserPreferencesService> userPreferencesService;
    @Mock
    protected UserPreferencesService userPreferencesServiceMock;
    @Spy
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    @Spy
    protected GridPreferencesStore gridPreferencesStore;
    @Mock
    protected User identity;

    protected abstract AbstractMultiGridView getView();

    protected abstract AbstractMultiGridPresenter getPresenter();

    public abstract List<String> getExpectedTabs();

    public abstract List<String> getExpectedInitialColumns();

    public abstract List<String> getExpectedBannedColumns();

    public abstract Integer getExpectedNumberOfColumns();

    @Before
    public void setupMocks() {
        this.userPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.getView().setUserPreferencesService(this.userPreferencesService);
        this.getView().setDataSetEditorManager(this.dataSetEditorManager);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(this.getView().getGridGlobalPreferencesKey(), UserPreferencesType.MULTIGRIDPREFERENCES)).thenReturn((Object)this.multiGridPreferencesStore);
        Mockito.when((Object)this.getPresenter().getDataProvider()).thenReturn((Object)this.dataProviderMock);
        Mockito.when((Object)this.getPresenter().createTableSettingsPrototype()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.getPresenter().createSearchTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterPagedTable.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStore);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(Mockito.anyString(), (UserPreferencesType)Mockito.eq((Object)UserPreferencesType.GRIDPREFERENCES))).thenReturn((Object)new GridPreferencesStore(new GridGlobalPreferences()));
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)TEST_USER_ID);
    }

    @Test
    public void initWithoutFiltersDefinedTest() {
        Mockito.when((Object)this.multiGridPreferencesStore.getSelectedGrid()).thenReturn((Object)"");
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(new ArrayList());
        this.getView().init(this.getPresenter());
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(this.getView().getGridGlobalPreferencesKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridView)Mockito.verify((Object)this.getView())).initDefaultFilters();
    }

    @Test
    public void initWithFilterStoredTest() {
        ArrayList<String> existingFilters = new ArrayList<String>();
        existingFilters.add(TEST_KEY_GRID1);
        existingFilters.add(TEST_KEY_GRID2);
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(existingFilters);
        this.getView().init(this.getPresenter());
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(this.getView().getGridGlobalPreferencesKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.getPresenter())).setAddingDefaultFilters(true);
        ((AbstractMultiGridView)Mockito.verify((Object)this.getView())).loadGridInstance(TEST_KEY_GRID1);
        ((AbstractMultiGridView)Mockito.verify((Object)this.getView())).loadGridInstance(TEST_KEY_GRID2);
    }

    @Test
    public void validKeyForAdditionalFilterIncludesUserDefinedTest() {
        this.getView().setFilterPagedTable(this.filterPagedTable);
        this.getView().getValidKeyForAdditionalListGrid(TEST_KEY);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).getValidKeyForAdditionalListGrid("TESTud_");
    }

    @Test
    public void selectFirstTabAndEnableQueriesTest() {
        this.getView().init(this.getPresenter());
        this.getView().getSelectFirstTabAndEnableQueriesCommand().execute();
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.getPresenter())).setAddingDefaultFilters(false);
        ((MultiGridPreferencesStore)Mockito.verify((Object)this.multiGridPreferencesStore, (VerificationMode)Mockito.times((int)2))).setSelectedGrid("base");
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).setSelectedTab();
    }

    @Test
    public void selectionIgnoreColumnTest() {
        ExtendedPagedTable extPagedTable = new ExtendedPagedTable(new GridGlobalPreferences());
        Column testCol = this.getView().createTextColumn("testCol", val -> val);
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        Assert.assertTrue((boolean)extPagedTable.removeSelectionIgnoreColumn(testCol));
        extPagedTable.addColumn(testCol, "");
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertTrue((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
    }

    @Test
    public void testCreateExtendedPagedTable_PreferenceKeySet() {
        String filterKey = "filterKey";
        this.getView().init(this.getPresenter());
        Mockito.reset((Object[])new AbstractMultiGridPresenter[]{this.getPresenter()});
        ExtendedPagedTable table = this.getView().createExtendedPagedTable(filterKey);
        Assert.assertEquals((Object)filterKey, (Object)table.getGridPreferencesStore().getPreferenceKey());
        table = this.getView().createExtendedPagedTable("base");
        Assert.assertEquals((Object)(this.getView().getGridGlobalPreferencesKey() + "base"), (Object)table.getGridPreferencesStore().getPreferenceKey());
    }

    @Test
    public void testSearchTabIsAddedSavedGrids() {
        String tab1 = "tab1";
        this.multiGridPreferencesStore.getGridsId().add("tab1");
        this.getView().init(this.getPresenter());
        Assert.assertEquals((long)2L, (long)this.multiGridPreferencesStore.getGridsId().size());
        Assert.assertEquals((Object)"base", this.multiGridPreferencesStore.getGridsId().get(0));
        Assert.assertEquals((Object)"tab1", this.multiGridPreferencesStore.getGridsId().get(1));
        this.assertTabAdded("base", "tab1");
    }

    @Test
    public void testSearchTabIsFirst() {
        String tab1 = "tab1";
        String tab2 = "tab2";
        this.multiGridPreferencesStore.getGridsId().add("tab1");
        this.multiGridPreferencesStore.getGridsId().add("tab2");
        this.multiGridPreferencesStore.getGridsId().add("base");
        this.getView().init(this.getPresenter());
        Assert.assertEquals((long)3L, (long)this.multiGridPreferencesStore.getGridsId().size());
        Assert.assertEquals((Object)"base", this.multiGridPreferencesStore.getGridsId().get(0));
        Assert.assertEquals((Object)"tab1", this.multiGridPreferencesStore.getGridsId().get(1));
        Assert.assertEquals((Object)"tab2", this.multiGridPreferencesStore.getGridsId().get(2));
        this.assertTabAdded("base", "tab1", "tab2");
    }

    @Test
    public void testInitialColumns() {
        List<String> expectedInitColumns = this.getExpectedInitialColumns();
        Assert.assertEquals((long)expectedInitColumns.size(), (long)this.getView().getInitColumns().size());
        for (int i = 0; i < expectedInitColumns.size(); ++i) {
            Assert.assertEquals((Object)expectedInitColumns.get(i), this.getView().getInitColumns().get(i));
        }
    }

    @Test
    public void testColumnPreferences() {
        List<String> expectedInitColumns = this.getExpectedInitialColumns();
        this.getView().init(this.getPresenter());
        List columnPreferences = this.getView().getListGrid().getGridPreferencesStore().getColumnPreferences();
        Assert.assertEquals((long)expectedInitColumns.size(), (long)columnPreferences.size());
        for (int i = 0; i < expectedInitColumns.size(); ++i) {
            Assert.assertEquals((Object)expectedInitColumns.get(i), (Object)((GridColumnPreference)columnPreferences.get(i)).getName());
        }
    }

    @Test
    public void testBannedColumns() {
        List bannedColumns = this.getView().getBannedColumns();
        Assert.assertEquals((long)this.getExpectedBannedColumns().size(), (long)bannedColumns.size());
        for (int i = 0; i < bannedColumns.size(); ++i) {
            Assert.assertEquals((Object)this.getExpectedBannedColumns().get(i), bannedColumns.get(i));
        }
    }

    @Test
    public void testInitDefaultFilters() {
        this.getView().initDefaultFilters();
        this.assertTabAdded(this.getExpectedTabs().toArray(new String[0]));
    }

    protected void assertTabAdded(String ... keys) {
        for (String key : keys) {
            ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), (String)Mockito.eq((Object)key), (Command)Mockito.any(Command.class), Mockito.eq((boolean)false));
        }
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)keys.length))).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), Mockito.anyString(), (Command)Mockito.any(Command.class), Mockito.eq((boolean)false));
    }

    @Test
    public void testDataStoreNameIsSet() {
        ExtendedPagedTable currentListGrid = (ExtendedPagedTable)Mockito.spy((Object)new ExtendedPagedTable(new GridGlobalPreferences()));
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        this.getView().initColumns(currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testInitColumns() {
        ExtendedPagedTable currentListGrid = (ExtendedPagedTable)Mockito.spy((Object)new ExtendedPagedTable(new GridGlobalPreferences()));
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == AbstractMultiGridViewTest.this.getExpectedNumberOfColumns().intValue() ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
    }
}

