/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import java.util.Optional;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

public abstract class AbstractScreenListPresenter<T>
extends AbstractListPresenter<T> {
    protected User identity;
    @Inject
    protected PlaceManager placeManager;
    protected PlaceRequest place;
    protected ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    private String selectedServerTemplate = "";

    @OnOpen
    public void onOpen() {
        this.setSelectedServerTemplate(this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    @OnFocus
    public void onFocus() {
        this.setSelectedServerTemplate(this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @Inject
    public void setIdentity(User identity) {
        this.identity = identity;
    }

    @Inject
    public void setServerTemplateSelectorMenuBuilder(ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        this.serverTemplateSelectorMenuBuilder = serverTemplateSelectorMenuBuilder;
    }

    public void onServerTemplateSelected(@Observes ServerTemplateSelected serverTemplateSelected) {
        this.setSelectedServerTemplate(serverTemplateSelected.getServerTemplateId());
    }

    public String getSelectedServerTemplate() {
        return this.selectedServerTemplate;
    }

    protected void setSelectedServerTemplate(String selectedServerTemplate) {
        String newServerTemplate = Optional.ofNullable(selectedServerTemplate).orElse("").trim();
        if (!this.selectedServerTemplate.equals(newServerTemplate)) {
            this.selectedServerTemplate = newServerTemplate;
            this.refreshGrid();
        }
    }
}

