/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ServerTemplateSelectorViewImpl
extends Composite
implements ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorView {
    private Constants constants = Constants.INSTANCE;
    private DropDownMenu dropDownServerTemplates;
    private Button serverTemplateButton;
    private ButtonGroup serverTemplates;
    private ParameterizedCommand<String> changeCommand;

    @PostConstruct
    public void init() {
        this.serverTemplateButton = (Button)GWT.create(Button.class);
        this.serverTemplateButton.setText(this.constants.ServerTemplates());
        this.serverTemplateButton.setDataToggle(Toggle.DROPDOWN);
        this.serverTemplateButton.setSize(ButtonSize.SMALL);
        this.dropDownServerTemplates = (DropDownMenu)GWT.create(DropDownMenu.class);
        this.dropDownServerTemplates.addStyleName("dropdown-menu-right");
        this.serverTemplates = (ButtonGroup)GWT.create(ButtonGroup.class);
        this.serverTemplates.add((Widget)this.serverTemplateButton);
        this.serverTemplates.add((Widget)this.dropDownServerTemplates);
        this.initWidget((Widget)this.serverTemplates);
    }

    @Override
    public void selectServerTemplate(String serverTemplateId) {
        for (Widget widget : this.dropDownServerTemplates) {
            if (!(widget instanceof AnchorListItem) || !((AnchorListItem)widget).getText().equals(serverTemplateId)) continue;
            this.selectServerTemplate((AnchorListItem)widget);
            break;
        }
    }

    @Override
    public void addServerTemplate(String serverTemplateId) {
        AnchorListItem serverTemplateNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        serverTemplateNavLink.setText(serverTemplateId);
        serverTemplateNavLink.setIcon(IconType.SERVER);
        serverTemplateNavLink.setIconFixedWidth(true);
        serverTemplateNavLink.addClickHandler(e -> this.selectServerTemplate(serverTemplateNavLink));
        this.dropDownServerTemplates.add((Widget)serverTemplateNavLink);
    }

    protected void selectServerTemplate(AnchorListItem serverTemplateNavLink) {
        boolean serverChanged = !serverTemplateNavLink.getText().equals(this.serverTemplateButton.getText());
        this.unselectAllServerTemplateNavLinks();
        serverTemplateNavLink.setActive(true);
        if (serverChanged) {
            this.serverTemplateButton.setText(serverTemplateNavLink.getText());
            if (this.changeCommand != null) {
                this.changeCommand.execute((Object)serverTemplateNavLink.getText());
            }
        }
    }

    @Override
    public void clearSelectedServerTemplate() {
        this.serverTemplateButton.setText(this.constants.ServerTemplates());
        if (this.changeCommand != null) {
            this.changeCommand.execute(null);
        }
    }

    @Override
    public String getSelectedServerTemplate() {
        String serverTemplate = this.serverTemplateButton.getText();
        return serverTemplate.equals(this.constants.ServerTemplates()) ? null : serverTemplate;
    }

    @Override
    public void removeAllServerTemplates() {
        Iterator iterator = this.dropDownServerTemplates.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public void setServerTemplateChangeHandler(ParameterizedCommand<String> command) {
        this.changeCommand = command;
    }

    private void unselectAllServerTemplateNavLinks() {
        for (Widget widget : this.dropDownServerTemplates) {
            if (!(widget instanceof AnchorListItem)) continue;
            ((AnchorListItem)widget).setActive(false);
        }
    }
}

