/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ErrorHandlerBuilderTest {
    @Mock
    DefaultWorkbenchErrorCallback errorCallback;
    @InjectMocks
    @Spy
    ErrorHandlerBuilder dataSetReadyCallback;

    @Before
    public void setup() {
        ((ErrorHandlerBuilder)Mockito.doNothing().when((Object)this.dataSetReadyCallback)).showErrorMessage((String)Mockito.any());
    }

    @Test
    public void testNotFound() {
        Command command = (Command)Mockito.mock(Command.class);
        this.dataSetReadyCallback.setEmptyResultsCallback(command);
        this.dataSetReadyCallback.notFound();
        ((Command)Mockito.verify((Object)command)).execute();
        ((ErrorHandlerBuilder)Mockito.verify((Object)this.dataSetReadyCallback)).showErrorMessage((String)Mockito.any());
        ((DefaultWorkbenchErrorCallback)Mockito.verify((Object)this.errorCallback, (VerificationMode)Mockito.never())).error((Throwable)Mockito.any());
    }

    @Test
    public void testOnError() {
        Command command = (Command)Mockito.mock(Command.class);
        this.dataSetReadyCallback.setEmptyResultsCallback(command);
        this.dataSetReadyCallback.onError((ClientRuntimeError)Mockito.mock(ClientRuntimeError.class));
        ((Command)Mockito.verify((Object)command)).execute();
        ((DefaultWorkbenchErrorCallback)Mockito.verify((Object)this.errorCallback)).error((Throwable)Mockito.any());
        ((ErrorHandlerBuilder)Mockito.verify((Object)this.dataSetReadyCallback, (VerificationMode)Mockito.never())).showErrorMessage((String)Mockito.any());
    }

    @Test
    public void testCallback() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.dataSetReadyCallback.setCallback(consumer);
        this.dataSetReadyCallback.callback((DataSet)Mockito.mock(DataSet.class));
        ((Consumer)Mockito.verify((Object)consumer)).accept(Mockito.any());
        ((DefaultWorkbenchErrorCallback)Mockito.verify((Object)this.errorCallback, (VerificationMode)Mockito.never())).error((Throwable)Mockito.any());
        ((ErrorHandlerBuilder)Mockito.verify((Object)this.dataSetReadyCallback, (VerificationMode)Mockito.never())).showErrorMessage((String)Mockito.any());
    }
}

