/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.advanced;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.filter.AdvancedFilterEditor;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AdvancedFiltersPresenter {
    private final Constants constants = Constants.INSTANCE;
    protected FilterSettingsManager filterSettingsManager;
    protected AdvancedFilterEditor advancedFilterEditorView;
    protected PlaceManager placeManager;
    private Event<SavedFilterSelectedEvent> savedFilterSelectedEvent;
    protected Event<NotificationEvent> notificationEvent;

    @WorkbenchPartView
    public AdvancedFilterEditor getView() {
        return this.advancedFilterEditorView;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.AdvancedFilters();
    }

    @OnOpen
    public void onOpen() {
        this.initAdvancedFilters();
    }

    protected void setFilterSettingsManager(FilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    public abstract String getAdvancedFiltersEditorScreenId();

    @Inject
    public void setAdvancedFilterEditorView(AdvancedFilterEditor advancedFilterEditorView) {
        this.advancedFilterEditorView = advancedFilterEditorView;
    }

    @Inject
    public void setSavedFilterSelectedEvent(Event<SavedFilterSelectedEvent> savedFilterSelectedEvent) {
        this.savedFilterSelectedEvent = savedFilterSelectedEvent;
    }

    @Inject
    public void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        this.notificationEvent = notificationEvent;
    }

    @Inject
    public void setPlaceManager(PlaceManager placeManager) {
        this.placeManager = placeManager;
    }

    public void displayNotification(String text) {
        this.notificationEvent.fire((Object)new NotificationEvent(text, NotificationEvent.NotificationType.SUCCESS));
    }

    private void initAdvancedFilters() {
        this.advancedFilterEditorView.init(this.filterSettingsManager.createFilterSettingsPrototype(), filterSettings -> this.filterSettingsManager.saveFilterIntoPreferences(filterSettings, state -> {
            if (state.booleanValue()) {
                this.displayNotification(Constants.INSTANCE.SavedFilterCorrectlyWithName(filterSettings.getTableName()));
                this.savedFilterSelectedEvent.fire((Object)new SavedFilterSelectedEvent(new SavedFilter(filterSettings.getKey(), filterSettings.getTableName())));
                this.placeManager.closePlace(this.getAdvancedFiltersEditorScreenId());
            } else {
                this.advancedFilterEditorView.setTableNameError(Constants.INSTANCE.FilterWithSameNameAlreadyExists());
            }
        }));
    }
}

