/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.active;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFiltersViewImpl;
import org.jbpm.workbench.common.client.filters.active.SaveFilterPopoverView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class ActiveFiltersViewImplTest {
    @Mock
    Popover saveFilterPopover;
    @Mock
    SaveFilterPopoverView saveFilterPopoverView;
    @Mock
    DataBinder<List<ActiveFilterItem>> activeFiltersList;
    @InjectMocks
    @Spy
    ActiveFiltersViewImpl view;

    @Test
    public void testSaveFilterCallback() {
        String name = "filterName";
        ((SaveFilterPopoverView)Mockito.doAnswer(invocation -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[0];
            callback.execute((Object)"filterName");
            return null;
        }).when((Object)this.saveFilterPopoverView)).setSaveCallback((ParameterizedCommand)Matchers.any());
        this.view.setSaveFilterPopoverCallback();
        ((ActiveFiltersViewImpl)Mockito.verify((Object)this.view)).saveFilter("filterName");
    }

    @Test
    public void testCancelFilterCallback() {
        ((SaveFilterPopoverView)Mockito.doAnswer(invocation -> {
            Command callback = (Command)invocation.getArguments()[0];
            callback.execute();
            return null;
        }).when((Object)this.saveFilterPopoverView)).setCancelCallback((Command)Matchers.any());
        this.view.setSaveFilterPopoverCallback();
        ((Popover)Mockito.verify((Object)this.saveFilterPopover)).hide();
    }

    @Test
    public void testRemoveActiveFilter() {
        ArrayList<ActiveFilterItem> model = new ArrayList<ActiveFilterItem>();
        Mockito.when((Object)this.activeFiltersList.getModel()).thenReturn(model);
        model.add(new ActiveFilterItem("key1", null, null, null, null));
        model.add(new ActiveFilterItem("key2", null, null, null, null));
        this.view.removeActiveFilter(new ActiveFilterItem("key1", null, null, null, null));
        this.view.removeActiveFilter(new ActiveFilterItem("key3", null, null, null, null));
        Assert.assertEquals((long)1L, (long)model.size());
        ((DataBinder)Mockito.verify(this.activeFiltersList, (VerificationMode)Mockito.times((int)2))).getModel();
    }
}

