/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import com.google.gwt.core.client.GWT;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;

@Dependent
public class ErrorHandlerBuilder
implements DataSetReadyCallback {
    private DefaultWorkbenchErrorCallback errorCallback;
    private String UUID;
    private Consumer<DataSet> callback;
    private Command emptyResultsCallback;

    @Inject
    public void setErrorCallback(DefaultWorkbenchErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    public void setCallback(Consumer<DataSet> callback) {
        this.callback = callback;
    }

    public void setUUID(String UUID) {
        this.UUID = UUID;
    }

    public void setEmptyResultsCallback(Command emptyResultsCallback) {
        this.emptyResultsCallback = emptyResultsCallback;
    }

    public ErrorHandlerBuilder withEmptyResultsCallback(Command command) {
        this.setEmptyResultsCallback(command);
        return this;
    }

    public ErrorHandlerBuilder withUUID(String UUID) {
        this.setUUID(UUID);
        return this;
    }

    public ErrorHandlerBuilder withDataSetCallback(Consumer<DataSet> dataSetCallback) {
        this.setCallback(dataSetCallback);
        return this;
    }

    protected void setEmptyResults() {
        if (this.emptyResultsCallback != null) {
            this.emptyResultsCallback.execute();
        }
    }

    public void notFound() {
        this.setEmptyResults();
        this.showErrorMessage(Constants.INSTANCE.DataSetNotFound(this.UUID));
        GWT.log((String)("DataSet with UUID [ " + this.UUID + " ] not found."));
    }

    public void showErrorMessage(String message) {
        ErrorPopup.showMessage((String)message);
    }

    public boolean onError(ClientRuntimeError error) {
        this.setEmptyResults();
        this.errorCallback.error(error.getThrowable());
        GWT.log((String)("DataSet with UUID [ " + this.UUID + " ] error: "), (Throwable)error.getThrowable());
        return false;
    }

    public void callback(DataSet dataSet) {
        this.callback.accept(dataSet);
    }
}

