/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Node;
import java.util.ArrayList;
import org.jbpm.workbench.common.client.resources.i18n.Constants;

public class SLAComplianceCell
extends AbstractCell<Integer> {
    private final Constants constants = Constants.INSTANCE;
    private static final String SLA_STYLE = "label";
    private static final String SLA_NA_PRESENT_STYLE = "label-default";
    private static final String SLA_PENDING_PRESENT_STYLE = "label-primary";
    private static final String SLA_MET_PRESENT_STYLE = "label-success";
    private static final String SLA_ABORTED_PRESENT_STYLE = "label-warning";
    private static final String SLA_VIOLATED_PRESENT_STYLE = "label-danger";

    public SLAComplianceCell() {
        super(new String[0]);
    }

    public void render(Cell.Context context, Integer value, SafeHtmlBuilder sb) {
        String description;
        ArrayList<String> tooltipClasses = new ArrayList<String>();
        tooltipClasses.add(SLA_STYLE);
        switch (value) {
            case 0: {
                description = this.constants.SlaNA();
                tooltipClasses.add(SLA_NA_PRESENT_STYLE);
                break;
            }
            case 1: {
                description = this.constants.SlaPending();
                tooltipClasses.add(SLA_PENDING_PRESENT_STYLE);
                break;
            }
            case 2: {
                description = this.constants.SlaMet();
                tooltipClasses.add(SLA_MET_PRESENT_STYLE);
                break;
            }
            case 4: {
                description = this.constants.SlaAborted();
                tooltipClasses.add(SLA_ABORTED_PRESENT_STYLE);
                break;
            }
            case 3: {
                description = this.constants.SlaViolated();
                tooltipClasses.add(SLA_VIOLATED_PRESENT_STYLE);
                break;
            }
            default: {
                description = this.constants.Unknown();
                tooltipClasses.add(SLA_NA_PRESENT_STYLE);
            }
        }
        Element span = DomGlobal.document.createElement("span");
        span.textContent = description;
        tooltipClasses.forEach(c -> span.classList.add(new String[]{c}));
        Element content = DomGlobal.document.createElement("span");
        content.appendChild((Node)span);
        sb.appendHtmlConstant(content.innerHTML);
    }
}

