/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Templated
public class ServerTemplateSelectorViewImpl
implements ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField
    private Div container;
    @Inject
    @DataField(value="selected-serverTemplate-text")
    Span selectedServerTemplateText;
    @Inject
    @DataField(value="server-templates-list")
    UnorderedList serverTemplatesList;
    private ParameterizedCommand<String> changeCommand;

    public void init(ServerTemplateSelectorMenuBuilder presenter) {
    }

    @Override
    public void selectServerTemplate(String serverTemplateId) {
        NodeList childList = this.serverTemplatesList.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getLastChild().getTextContent().equals(serverTemplateId)) continue;
            this.selectServerTemplate((HTMLElement)childList.item(i), serverTemplateId, false);
            break;
        }
    }

    @Override
    public void updateSelectedValue(String serverTemplateId) {
        NodeList childList = this.serverTemplatesList.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getLastChild().getTextContent().equals(serverTemplateId)) continue;
            this.selectServerTemplate((HTMLElement)childList.item(i), serverTemplateId, true);
            break;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            DOMUtil.removeCSSClass((HTMLElement)this.container, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.container, (String)"hidden");
        }
    }

    @Override
    public void addServerTemplate(String serverTemplateId) {
        HTMLElement li = Window.getDocument().createElement("li");
        HTMLElement a = Window.getDocument().createElement("a");
        HTMLElement textSpan = Window.getDocument().createElement("span");
        textSpan.setTextContent(serverTemplateId);
        a.setOnclick(e -> this.selectServerTemplate(li, serverTemplateId, false));
        a.appendChild((Node)textSpan);
        li.appendChild((Node)a);
        this.serverTemplatesList.appendChild((Node)li);
    }

    protected void selectServerTemplate(HTMLElement liOption, String serverTemplateId, boolean updating) {
        boolean serverChanged = !serverTemplateId.equals(this.selectedServerTemplateText.getTextContent());
        this.unSelectAllServerTemplateNavLinks();
        DOMUtil.addCSSClass((HTMLElement)liOption, (String)"active");
        if (serverChanged) {
            this.selectedServerTemplateText.setTextContent(serverTemplateId);
            if (this.changeCommand != null && !updating) {
                this.changeCommand.execute((Object)serverTemplateId);
            }
        }
    }

    @Override
    public void clearSelectedServerTemplate() {
        this.selectedServerTemplateText.setTextContent(this.constants.ServerTemplates());
        if (this.changeCommand != null) {
            this.changeCommand.execute(null);
        }
    }

    @Override
    public String getSelectedServerTemplate() {
        String serverTemplate = this.selectedServerTemplateText.getTextContent();
        return serverTemplate.equals(this.constants.ServerTemplates()) ? null : serverTemplate;
    }

    @Override
    public void removeAllServerTemplates() {
        DOMUtil.removeAllChildren((Node)this.serverTemplatesList);
    }

    @Override
    public void setServerTemplateChangeHandler(ParameterizedCommand<String> command) {
        this.changeCommand = command;
    }

    private void unSelectAllServerTemplateNavLinks() {
        NodeList childList = this.serverTemplatesList.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)childList.item(i)), (String)"active");
        }
    }

    public HTMLElement getElement() {
        return this.container;
    }
}

