/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.uberfire.client.views.pfly.widgets.Moment;

public class DateUtils {
    public static String DEFAULT_DATE_FORMAT_MASK = "dd/MM/yyyy";
    public static String DEFAULT_DATE_AND_TIME_FORMAT_MASK = "dd/MM/yyyy HH:mm";
    public static String DEFAULT_TIME_FORMAT_MASK = "HH:mm";

    public static Date createDate(String dateString) {
        return DateUtils.createDate(dateString, "yyyy-MM-dd");
    }

    public static Date createDate(String dateString, String dateFormat) {
        DateTimeFormat fmt = DateTimeFormat.getFormat((String)dateFormat);
        return fmt.parse(dateString);
    }

    public static String getDateFormatMask() {
        try {
            String fmt = ApplicationPreferences.getDroolsDateFormat();
            return fmt != null ? fmt : DEFAULT_DATE_FORMAT_MASK;
        }
        catch (Exception e) {
            return DEFAULT_DATE_FORMAT_MASK;
        }
    }

    public static String getDateTimeFormatMask() {
        try {
            String fmt = ApplicationPreferences.getDroolsDateTimeFormat();
            return fmt != null ? fmt : DEFAULT_DATE_AND_TIME_FORMAT_MASK;
        }
        catch (Exception e) {
            return DEFAULT_DATE_AND_TIME_FORMAT_MASK;
        }
    }

    public static String getDateStr(Date date) {
        if (date != null) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)DateUtils.getDateFormatMask());
            return format.format(date);
        }
        return "";
    }

    public static String getDateTimeStr(Date date) {
        if (date != null) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)DateUtils.getDateTimeFormatMask());
            return format.format(date);
        }
        return "";
    }

    public static String getPrettyTime(Date date) {
        if (date != null) {
            return Moment.Builder.moment((Long)date.getTime()).fromNow();
        }
        return "";
    }
}

