/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.client.Timer;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractListPresenterTest {
    @Mock
    ExtendedPagedTable extendedPagedTable;
    @Mock
    HasData next;
    @Mock
    AsyncDataProvider dataProviderMock;
    @Mock
    private Timer timer;
    @Mock
    private ListView viewMock;
    private AbstractListPresenter testListPresenter;

    @Before
    public void setupMocks() {
        this.testListPresenter = (AbstractListPresenter)Mockito.spy(AbstractScreenListPresenter.class);
        Mockito.when((Object)this.testListPresenter.getListView()).thenReturn((Object)this.viewMock);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.next.getVisibleRange()).thenReturn((Object)new Range(1, 1));
        this.testListPresenter.initDataProvider();
        this.testListPresenter.getDataProvider().addDataDisplay(this.next);
    }

    @Test
    public void autoRefreshDisabledByDefaultTest() {
        this.testListPresenter.setRefreshTimer(null);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertNotNull((Object)this.testListPresenter.getRefreshTimer());
        Assert.assertFalse((boolean)this.testListPresenter.isAutoRefreshEnabled());
        this.testListPresenter.setRefreshTimer(this.timer);
        this.testListPresenter.setAutoRefreshSeconds(60);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertFalse((boolean)this.testListPresenter.isAutoRefreshEnabled());
        ((Timer)Mockito.verify((Object)this.timer)).cancel();
    }

    @Test
    public void autoRefreshEnabledScheduleTimerTest() {
        this.testListPresenter.setAutoRefreshEnabled(true);
        this.testListPresenter.setAutoRefreshSeconds(60);
        this.testListPresenter.setRefreshTimer(this.timer);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertNotNull((Object)this.testListPresenter.getRefreshTimer());
        ((Timer)Mockito.verify((Object)this.timer)).cancel();
        ((Timer)Mockito.verify((Object)this.timer)).schedule(60000);
    }

    @Test
    public void restoreTabsTest() {
        this.testListPresenter.onRestoreDefaultFilters();
        ((ListView)Mockito.verify((Object)this.viewMock)).showRestoreDefaultFilterConfirmationPopup();
    }

    @Test
    public void testUpDateDataOnCallBackFirstPage() {
        ArrayList<String> instanceSummaries = new ArrayList<String>();
        instanceSummaries.add("item1");
        instanceSummaries.add("item2");
        int startRange = 0;
        this.testListPresenter.setDataProvider(this.dataProviderMock);
        this.testListPresenter.updateDataOnCallback(instanceSummaries, startRange, startRange + instanceSummaries.size(), false);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProviderMock)).updateRowCount(2, false);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProviderMock)).updateRowData(0, instanceSummaries);
        ((ExtendedPagedTable)Mockito.verify((Object)this.extendedPagedTable)).setVisibleSelectedItems();
    }

    @Test
    public void testUpDateDataOnCallBackMiddlePage() {
        ArrayList<String> instanceSummaries = new ArrayList<String>();
        instanceSummaries.add("item1");
        instanceSummaries.add("item2");
        int startRange = 10;
        this.testListPresenter.setDataProvider(this.dataProviderMock);
        this.testListPresenter.updateDataOnCallback(instanceSummaries, startRange, startRange + instanceSummaries.size(), true);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProviderMock)).updateRowCount(startRange + instanceSummaries.size(), true);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProviderMock)).updateRowData(startRange, instanceSummaries);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
    }

    @Test
    public void testRefreshGrid() {
        Range range = new Range(0, 5);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getVisibleRange()).thenReturn((Object)range);
        this.testListPresenter.refreshGrid();
        ((ExtendedPagedTable)Mockito.verify((Object)this.extendedPagedTable)).setVisibleRangeAndClearData(range, true);
    }
}

