/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.model.GenericSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.DataGrid;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExtendedPagedTableTest {
    @Mock
    GridGlobalPreferences preferences;
    @Mock
    DataGrid dataGrid;
    ExtendedPagedTable table;

    @Before
    public void setup() {
        this.table = new ExtendedPagedTable(this.preferences);
        this.table.dataGrid = this.dataGrid;
    }

    @Test
    public void testHasSelectedItems() {
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.table.hasSelectedItems());
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)gs.isSelected()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Arrays.asList(gs, gs));
        Assert.assertTrue((boolean)this.table.hasSelectedItems());
    }

    @Test
    public void testDeselectAllItems() {
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Arrays.asList(gs, gs));
        this.table.deselectAllItems();
        ((GenericSummary)Mockito.verify((Object)gs, (VerificationMode)Mockito.times((int)2))).setSelected(false);
    }

    @Test
    public void setItemSelectedSelectionTest() {
        GenericSummary gs_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        ArrayList<GenericSummary> selectedItems = new ArrayList<GenericSummary>();
        selectedItems.add(gs_selected);
        this.table.setSelectedItems(selectedItems);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_selected, true);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_selected, false);
        this.checkSelectedItemsContent(0, new GenericSummary[0]);
    }

    @Test
    public void setItemNotSelectedSelectionTest() {
        GenericSummary gs_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        GenericSummary gs_new_selection = (GenericSummary)Mockito.mock(GenericSummary.class);
        ArrayList<GenericSummary> selectedItems = new ArrayList<GenericSummary>();
        selectedItems.add(gs_selected);
        this.table.setSelectedItems(selectedItems);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_new_selection, true);
        this.checkSelectedItemsContent(2, (GenericSummary)this.table.getSelectedItems().get(0), (GenericSummary)this.table.getSelectedItems().get(1));
        this.table.setItemSelection(gs_new_selection, false);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
    }

    private void checkSelectedItemsContent(int size, GenericSummary ... genericSummary) {
        Assert.assertEquals((long)size, (long)this.table.getSelectedItems().size());
        for (int i = 0; i < genericSummary.length; ++i) {
            Assert.assertEquals((Object)genericSummary[i], this.table.getSelectedItems().get(i));
        }
    }

    @Test
    public void testSetVisibleSelectedItems() {
        GenericSummary gs_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        GenericSummary gs_not_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        ArrayList<GenericSummary> selectedItems = new ArrayList<GenericSummary>();
        selectedItems.add(gs_selected);
        this.table.setSelectedItems(selectedItems);
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Arrays.asList(gs_selected, gs_not_selected));
        this.table.setVisibleSelectedItems();
        ((GenericSummary)Mockito.verify((Object)gs_selected)).setSelected(true);
        ((GenericSummary)Mockito.verify((Object)gs_not_selected)).setSelected(false);
    }

    @Test
    public void testIsAllItemsSelected() {
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)gs.isSelected()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        List list1 = Collections.emptyList();
        List<GenericSummary> list2 = Arrays.asList(gs, gs);
        List<GenericSummary> list3 = Collections.singletonList(gs);
        Mockito.when((Object)this.dataGrid.getVisibleItemCount()).thenReturn((Object)list1.size(), (Object[])new Integer[]{list2.size(), list3.size()});
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(list2, (Object[])new List[]{list3});
        Assert.assertFalse((boolean)this.table.isAllItemsSelected());
        Assert.assertTrue((boolean)this.table.isAllItemsSelected());
        Assert.assertFalse((boolean)this.table.isAllItemsSelected());
    }
}

