/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import com.google.gwt.core.client.GWT;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

public abstract class AbstractDataSetReadyCallback
implements DataSetReadyCallback {
    private DefaultWorkbenchErrorCallback errorCallback;
    private ErrorPopupPresenter errorPopup;
    private ListView view;
    private String UUID;

    public AbstractDataSetReadyCallback(ErrorPopupPresenter errorPopup, ListView view, String UUID) {
        this(errorPopup, view, UUID, new DefaultWorkbenchErrorCallback());
    }

    public AbstractDataSetReadyCallback(ErrorPopupPresenter errorPopup, ListView view, String UUID, DefaultWorkbenchErrorCallback errorCallback) {
        this.errorPopup = errorPopup;
        this.view = view;
        this.UUID = UUID;
        this.errorCallback = errorCallback;
    }

    public void notFound() {
        this.view.hideBusyIndicator();
        this.errorPopup.showMessage(Constants.INSTANCE.DataSetNotFound(this.UUID));
        GWT.log((String)("DataSet with UUID [ " + this.UUID + " ] not found."));
    }

    public boolean onError(ClientRuntimeError error) {
        this.view.hideBusyIndicator();
        this.errorCallback.error(null, error.getThrowable());
        GWT.log((String)("DataSet with UUID [ " + this.UUID + " ] error: "), (Throwable)error.getThrowable());
        return false;
    }
}

