/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.List;
import javax.enterprise.event.Observes;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.event.DeselectAllItemsEvent;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.model.QueryFilter;
import org.uberfire.paging.PageResponse;

public abstract class AbstractListPresenter<T>
implements RefreshMenuBuilder.SupportsRefresh {
    protected AsyncDataProvider<T> dataProvider;
    protected QueryFilter currentFilter;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public AbstractListPresenter() {
        this.initDataProvider();
    }

    protected abstract ListView getListView();

    public abstract void getData(Range var1);

    protected void initDataProvider() {
        this.dataProvider = new AsyncDataProvider<T>(){

            protected void onRangeChanged(HasData<T> display) {
                AbstractListPresenter.this.getListView().showBusyIndicator(AbstractListPresenter.this.constants.Loading());
                Range visibleRange = display.getVisibleRange();
                AbstractListPresenter.this.getData(visibleRange);
            }
        };
    }

    public void updateDataOnCallback(PageResponse response) {
        this.updateDataOnCallback(response.getPageRowList(), response.getStartRowIndex(), response.getTotalRowSize(), response.isTotalRowSizeExact());
    }

    public void updateDataOnCallback(List<T> instanceSummaries, int startRange, int totalRowCount, boolean isExact) {
        this.dataProvider.updateRowCount(totalRowCount, isExact);
        this.dataProvider.updateRowData(startRange, instanceSummaries);
        this.getListView().hideBusyIndicator();
    }

    public void addDataDisplay(HasData<T> display) {
        if (this.dataProvider.getDataDisplays().size() == 1) {
            this.dataProvider.removeDataDisplay((HasData)this.dataProvider.getDataDisplays().iterator().next());
        }
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    protected void setDataProvider(AsyncDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void onRefresh() {
        this.refreshGrid();
    }

    public void refreshGrid() {
        if (this.getListView().getListGrid() != null) {
            this.getListView().getListGrid().setVisibleRangeAndClearData(this.getListView().getListGrid().getVisibleRange(), true);
        }
    }

    public void onDeselectAllItemsEvent(@Observes DeselectAllItemsEvent event) {
        this.deselectAllItems();
    }

    public void deselectAllItems() {
        if (this.getListView().getListGrid() != null) {
            this.getListView().getListGrid().deselectAllItems();
        }
    }
}

