/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.active;

import com.google.gwt.event.dom.client.KeyDownEvent;
import elemental2.dom.Event;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@Dependent
public class SaveFilterPopoverView
implements IsElement {
    @Inject
    @DataField(value="content")
    HTMLDivElement content;
    @Inject
    @DataField(value="input-group")
    HTMLDivElement inputGroup;
    @Inject
    @DataField(value="save")
    HTMLButtonElement save;
    @Inject
    @DataField(value="cancel")
    HTMLButtonElement cancel;
    @Inject
    @DataField(value="name")
    HTMLInputElement filterName;
    @Inject
    @DataField(value="error")
    @Named(value="span")
    HTMLElement error;
    private Command cancelCallback;
    private ParameterizedCommand<String> saveCallback;

    public void setCancelCallback(Command cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    public void setSaveCallback(ParameterizedCommand<String> saveCallback) {
        this.saveCallback = saveCallback;
    }

    public HTMLElement getElement() {
        return this.content;
    }

    @EventHandler(value={"save"})
    public void onSave(@ForEvent(value={"click"}) Event e) {
        if (this.saveCallback != null) {
            this.saveCallback.execute((Object)this.filterName.value);
        }
    }

    @EventHandler(value={"name"})
    public void onKeyPressEvent(KeyDownEvent e) {
        if (e.getNativeKeyCode() == 13) {
            e.preventDefault();
            this.onSave(null);
        }
    }

    public void onOpen() {
        this.filterName.value = "";
        this.error.textContent = "";
        this.inputGroup.classList.remove(new String[]{"has-error"});
    }

    public void onShow() {
        this.filterName.focus();
    }

    public void setError(String message) {
        this.error.textContent = message;
        this.inputGroup.classList.add(new String[]{"has-error"});
    }

    @EventHandler(value={"cancel"})
    public void onCancel(@ForEvent(value={"click"}) Event e) {
        if (this.cancelCallback != null) {
            this.cancelCallback.execute();
        }
    }
}

