/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.client.ui.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.OptionsCollection;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.dataset.DataSetAwareSelect;
import org.jbpm.workbench.common.client.list.ActiveFilterItem;
import org.jbpm.workbench.common.client.list.ActiveFilterItemRemoved;
import org.jbpm.workbench.common.client.list.ActiveFilterItemView;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersView;
import org.jbpm.workbench.common.client.list.DatePickerRange;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateRange;
import org.uberfire.client.views.pfly.widgets.DateRangePicker;
import org.uberfire.client.views.pfly.widgets.DateRangePickerOptions;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated
public class AdvancedSearchFiltersViewImpl
extends Composite
implements AdvancedSearchFiltersView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="dropdown-filter-text")
    Span filterText;
    @Inject
    @DataField(value="date-dropdown-filter-text")
    Span dateFilterText;
    @Inject
    @DataField(value="active-filters-text")
    Span activeFiltersText;
    @Inject
    @DataField(value="filters-input")
    Div filtersInput;
    @Inject
    @DataField(value="filters-input-help")
    Anchor filtersInputHelp;
    @Inject
    @DataField(value="date-filters-input")
    Div dateFiltersInput;
    @Inject
    @DataField(value="remove-all-filters")
    Anchor removeAll;
    @Inject
    @DataField(value="filters")
    UnorderedList filters;
    @Inject
    @DataField(value="date-filters")
    UnorderedList dateFilters;
    @Inject
    @DataField(value="active-filters")
    @ListContainer(value="ul")
    @Bound
    private ListComponent<ActiveFilterItem, ActiveFilterItemView> activeFilters;
    @Inject
    @AutoBound
    private DataBinder<List<ActiveFilterItem>> activeFiltersList;
    @Inject
    @DataField(value="select-filters")
    private Div selectFilters;
    @Inject
    @DataField(value="date-caret")
    private Span dateCaret;
    @Inject
    @DataField(value="date-button")
    private Button dateButton;
    @Inject
    private ManagedInstance<Select> selectProvider;
    @Inject
    private ManagedInstance<DateRangePicker> dateRangePickerProvider;
    @Inject
    private ManagedInstance<DataSetAwareSelect> dataSetSelectProvider;
    @Inject
    private JQueryProducer.JQuery<Popover> jQueryPopover;

    @PostConstruct
    public void init() {
        this.removeAll.setTextContent(this.constants.ClearAll());
        this.activeFiltersText.setTextContent(this.constants.ActiveFilters());
        this.activeFiltersList.setModel(new ArrayList());
        this.activeFilters.addComponentCreationHandler(v -> DOMUtil.removeCSSClass((HTMLElement)this.removeAll, (String)"hidden"));
        this.activeFilters.addComponentDestructionHandler(v -> {
            if (((List)this.activeFiltersList.getModel()).isEmpty()) {
                DOMUtil.addCSSClass((HTMLElement)this.removeAll, (String)"hidden");
            }
            v.getValue().getCallback().accept(v.getValue().getValue());
        });
        this.filtersInputHelp.setAttribute("data-content", this.getInputStringHelpHtml());
        ((Popover)this.jQueryPopover.wrap((Element)this.filtersInputHelp)).popover();
    }

    private String getInputStringHelpHtml() {
        return "<p>" + this.constants.AllowedWildcardsForStrings() + "</p>\n <ul>\n   <li><code>_</code> - " + this.constants.ASubstituteForASingleCharacter() + "</li>\n   <li><code>%</code> - " + this.constants.ASubstituteForZeroOrMoreCharacters() + "</li>\n </ul>\n";
    }

    @Override
    public void addTextFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        DOMUtil.removeCSSClass((HTMLElement)this.filtersInputHelp, (String)"hidden");
        this.createFilterOption(label, (HTMLElement)this.filters, e -> this.setInputCurrentFilter(label));
        this.createInput(label, placeholder, input -> input.setType("text"), addCallback, removeCallback);
    }

    @Override
    public void addNumericFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.createFilterOption(label, (HTMLElement)this.filters, e -> this.setInputCurrentFilter(label));
        this.createInput(label, placeholder, input -> {
            input.setType("number");
            input.setAttribute("min", "0");
            input.addEventListener("keypress", this.getNumericInputListener(), false);
        }, addCallback, removeCallback);
    }

    protected EventListener<KeyboardEvent> getNumericInputListener() {
        return e -> {
            int keyCode = e.getKeyCode();
            if (keyCode <= 0) {
                keyCode = e.getWhich();
            }
            if (!(keyCode >= 96 && keyCode <= 105 || keyCode >= 48 && keyCode <= 57 || keyCode == 8 || keyCode == 37 || keyCode == 39)) {
                e.preventDefault();
            }
        };
    }

    @Override
    public void addDataSetSelectFilter(String label, String tableKey, DataSetLookup lookup, String textColumnId, String valueColumnId, Consumer<String> addCallback, Consumer<String> removeCallback) {
        DataSetAwareSelect select = (DataSetAwareSelect)this.dataSetSelectProvider.get();
        select.setDataSetLookup(lookup);
        select.setTextColumnId(textColumnId);
        select.setValueColumnId(valueColumnId);
        select.setTableKey(tableKey);
        this.setupSelect(label, false, select.getSelect(), addCallback, removeCallback);
    }

    @Override
    public void addDateRangeFilter(String label, String placeholder, Boolean useMaxDate, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        DateRangePicker dateRangePicker = (DateRangePicker)this.dateRangePickerProvider.get();
        dateRangePicker.getElement().setReadOnly(true);
        dateRangePicker.getElement().setAttribute("placeholder", placeholder);
        dateRangePicker.getElement().getClassList().add("form-control");
        DateRangePickerOptions options = this.getDateRangePickerOptions(useMaxDate);
        dateRangePicker.setup(options, null);
        dateRangePicker.addApplyListener((e, p) -> {
            Optional<DatePickerRange> datePickerRange = DatePickerRange.getDatePickerRangeFromLabel(p.getChosenLabel());
            this.onDateRangeValueChange(label, datePickerRange.isPresent() ? datePickerRange.get().getLabel() : this.constants.Custom(), datePickerRange.isPresent() ? datePickerRange.get().getStartDate() : p.getStartDate(), datePickerRange.isPresent() ? datePickerRange.get().getEndDate() : p.getEndDate(), addCallback, removeCallback);
        });
        Div div = (Div)Window.getDocument().createElement("div");
        div.setAttribute("data-filter", label);
        div.getClassList().add("input-group");
        div.getClassList().add("filter-control");
        div.getClassList().add("hidden");
        div.appendChild((Node)dateRangePicker.getElement());
        this.dateFiltersInput.appendChild((Node)div);
        this.createFilterOption(label, (HTMLElement)this.dateFilters, e -> this.setDateCurrentFilter(label));
        if (this.dateFilterText.getTextContent().isEmpty()) {
            this.setDateCurrentFilter(label);
        } else {
            DOMUtil.removeCSSClass((HTMLElement)this.dateCaret, (String)"hidden");
            this.dateButton.setAttribute("data-toggle", "dropdown");
        }
    }

    protected DateRangePickerOptions getDateRangePickerOptions(Boolean useMaxDate) {
        DateRangePickerOptions options = DateRangePickerOptions.create();
        options.setAutoUpdateInput(Boolean.valueOf(false));
        options.setAutoApply(Boolean.valueOf(true));
        options.setTimePicker(Boolean.valueOf(true));
        options.setTimePickerIncrement(30);
        if (useMaxDate.booleanValue()) {
            options.setMaxDate(Moment.Builder.moment().endOf("day"));
        }
        for (DatePickerRange range : DatePickerRange.values()) {
            options.addRange(range.getLabel(), range.getStartDate(), range.getEndDate().endOf("day"));
        }
        return options;
    }

    protected void onDateRangeValueChange(String label, String selectedLabel, Moment fromDate, Moment toDate, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        DateRange dateRange = new DateRange(fromDate.milliseconds(0).asDate(), toDate.milliseconds(0).asDate());
        String hint = this.constants.From() + ": " + fromDate.format("lll") + "<br>" + this.constants.To() + ": " + toDate.format("lll");
        this.addActiveFilter(label, selectedLabel, hint, dateRange, removeCallback);
        addCallback.accept(dateRange);
    }

    @Override
    public void addSelectFilter(String label, Map<String, String> options, Boolean liveSearch, Consumer<String> addCallback, Consumer<String> removeCallback) {
        Select select = (Select)this.selectProvider.get();
        options.forEach((k, v) -> select.addOption(v, k));
        this.setupSelect(label, liveSearch, select, addCallback, removeCallback);
    }

    private void setupSelect(String label, Boolean liveSearch, Select select, Consumer<String> addCallback, Consumer<String> removeCallback) {
        select.setTitle(label);
        select.setLiveSearch(liveSearch);
        select.setWidth("auto");
        select.getElement().getClassList().add("selectpicker");
        select.getElement().getClassList().add("form-control");
        this.selectFilters.appendChild((Node)select.getElement());
        select.refresh();
        select.getElement().addEventListener("change", event -> {
            if (!select.getValue().isEmpty()) {
                OptionsCollection options = select.getOptions();
                for (int i = 0; i < options.getLength(); ++i) {
                    Option item = (Option)options.item(i);
                    if (!item.getSelected()) continue;
                    this.addActiveFilter(label, item.getText(), select.getValue(), removeCallback);
                    addCallback.accept(select.getValue());
                    select.setValue("");
                    break;
                }
            }
        }, false);
    }

    private void createInput(String label, String placeholder, Consumer<Input> customizeCallback, Consumer<String> addCallback, Consumer<String> removeCallback) {
        Input input = (Input)Window.getDocument().createElement("input");
        customizeCallback.accept(input);
        input.setAttribute("placeholder", placeholder);
        input.setAttribute("data-filter", label);
        input.getClassList().add("form-control");
        input.getClassList().add("filter-control");
        input.getClassList().add("hidden");
        input.addEventListener("keypress", e -> {
            if (e.getKeyCode() == 13 && !input.getValue().isEmpty()) {
                this.addActiveFilter(label, input.getValue(), input.getValue(), removeCallback);
                addCallback.accept(input.getValue());
                input.setValue("");
            }
        }, false);
        this.filtersInput.appendChild((Node)input);
        if (this.filterText.getTextContent().isEmpty()) {
            this.setInputCurrentFilter(label);
        }
    }

    private void createFilterOption(String label, HTMLElement element, EventListener listener) {
        Anchor a = (Anchor)Window.getDocument().createElement("a");
        a.setTextContent(label);
        a.addEventListener("click", listener, false);
        ListItem li = (ListItem)Window.getDocument().createElement("li");
        li.setAttribute("data-filter", label);
        li.appendChild((Node)a);
        element.appendChild((Node)li);
    }

    public void setInputCurrentFilter(String label) {
        this.setCurrentFilter(label, (HTMLElement)this.filterText, (HTMLElement)this.filters, (HTMLElement)this.filtersInput);
    }

    public void setDateCurrentFilter(String label) {
        this.setCurrentFilter(label, (HTMLElement)this.dateFilterText, (HTMLElement)this.dateFilters, (HTMLElement)this.dateFiltersInput);
    }

    private void setCurrentFilter(String label, HTMLElement text, HTMLElement optionsText, HTMLElement options) {
        text.setTextContent(label);
        for (Element child : DOMUtil.elementIterable((NodeList)optionsText.getChildNodes())) {
            if (label.equals(child.getAttribute("data-filter"))) {
                DOMUtil.addCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
                continue;
            }
            DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
        }
        for (Element child : DOMUtil.elementIterable((NodeList)options.getChildNodes())) {
            if (label.equals(child.getAttribute("data-filter"))) {
                DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
                continue;
            }
            DOMUtil.addCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
        }
    }

    @Override
    public <T> void addActiveFilter(String labelKey, String labelValue, T value, Consumer<T> removeCallback) {
        this.addActiveFilter(labelKey, labelValue, null, value, removeCallback);
    }

    protected <T> void addActiveFilter(String labelKey, String labelValue, String hint, T value, Consumer<T> removeCallback) {
        ((List)this.activeFiltersList.getModel()).removeIf(f -> f.getLabelKey().equals(labelKey));
        ((List)this.activeFiltersList.getModel()).add(new ActiveFilterItem<T>(labelKey, labelValue, hint, value, removeCallback));
    }

    public void onRemoveActiveFilter(@Observes ActiveFilterItemRemoved event) {
        ((List)this.activeFiltersList.getModel()).remove(event.getActiveFilterItem());
    }

    @EventHandler(value={"remove-all-filters"})
    public void onRemoveAll(@ForEvent(value={"click"}) Event e) {
        this.removeAllActiveFilters();
    }

    @Override
    public void removeAllActiveFilters() {
        ((List)this.activeFiltersList.getModel()).clear();
    }
}

