/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.saved;

import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterAsDefaultActiveEvent;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.filter.SavedFilter;

@Dependent
@Templated
public class SavedFilterView
extends Composite
implements TakesValue<SavedFilter> {
    @Inject
    @DataField(value="name")
    @Bound
    HTMLButtonElement name;
    @Inject
    @DataField(value="remove")
    HTMLButtonElement remove;
    @Inject
    @DataField(value="set-as-default")
    HTMLButtonElement setDefaultBtn;
    @Inject
    @Named(value="span")
    @DataField(value="set-as-default-icon")
    HTMLElement setDefaultIcon;
    @Inject
    @AutoBound
    private DataBinder<SavedFilter> dataBinder;
    @Inject
    private Event<SavedFilterRemoveEvent> savedFilterRemoveEvent;
    @Inject
    private Event<SavedFilterAsDefaultActiveEvent> savedFilterAsDefaultEventEvent;
    @Inject
    private Event<SavedFilterSelectedEvent> savedFilterSelectedEvent;

    @PostConstruct
    public void init() {
        this.remove.title = Constants.INSTANCE.Remove();
    }

    public SavedFilter getValue() {
        return (SavedFilter)this.dataBinder.getModel();
    }

    public void setValue(SavedFilter savedFilter) {
        this.showAsSelectedFilter(savedFilter.isDefaultFilter());
        this.dataBinder.setModel((Object)savedFilter);
    }

    @EventHandler(value={"remove"})
    public void onRemove(@ForEvent(value={"click"}) elemental2.dom.Event e) {
        this.savedFilterRemoveEvent.fire((Object)new SavedFilterRemoveEvent(this.getValue()));
    }

    @EventHandler(value={"set-as-default"})
    public void onSetAsDefaultFilter(@ForEvent(value={"click"}) elemental2.dom.Event e) {
        if (!this.getValue().isDefaultFilter()) {
            this.savedFilterAsDefaultEventEvent.fire((Object)new SavedFilterAsDefaultActiveEvent(this.getValue()));
        }
    }

    @EventHandler(value={"name"})
    public void onFilterSelected(@ForEvent(value={"click"}) elemental2.dom.Event e) {
        this.savedFilterSelectedEvent.fire((Object)new SavedFilterSelectedEvent(this.getValue()));
    }

    public void showAsSelectedFilter(boolean selected) {
        if (selected) {
            this.setDefaultBtn.title = Constants.INSTANCE.DefaultFilter();
            this.setDefaultIcon.className = "fa fa-check-circle";
        } else {
            this.setDefaultBtn.title = Constants.INSTANCE.SetAsDefaultFilter();
            this.setDefaultIcon.className = "fa fa-circle";
        }
    }
}

