/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.client.views.pfly.widgets.Moment;

public enum DatePickerRange {
    LastHour(Constants.INSTANCE.LastHour(), () -> Moment.Builder.moment().subtract(1, "hours"), () -> Moment.Builder.moment()),
    Today(Constants.INSTANCE.Today(), () -> Moment.Builder.moment().startOf("day"), () -> Moment.Builder.moment()),
    Last24Hours(Constants.INSTANCE.LastHours(24), () -> Moment.Builder.moment().subtract(24, "hours"), () -> Moment.Builder.moment()),
    Last7Days(Constants.INSTANCE.LastDays(7), () -> Moment.Builder.moment().subtract(7, "days").startOf("day"), () -> Moment.Builder.moment()),
    Last30Days(Constants.INSTANCE.LastDays(30), () -> Moment.Builder.moment().subtract(30, "days").startOf("day"), () -> Moment.Builder.moment());

    private String label;
    private Supplier<Moment> startDate;
    private Supplier<Moment> endDate;

    private DatePickerRange(String label, Supplier<Moment> startDate, Supplier<Moment> endDate) {
        this.label = label;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static Optional<DatePickerRange> getDatePickerRangeFromLabel(String label) {
        return Arrays.stream(DatePickerRange.values()).filter(e -> e.getLabel().equals(label)).findFirst();
    }

    public String getLabel() {
        return this.label;
    }

    public Moment getStartDate() {
        return this.startDate.get();
    }

    public Moment getEndDate() {
        return this.endDate.get();
    }
}

