/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.perspectives;

import com.google.gwt.core.client.Scheduler;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.panels.impl.MultiScreenWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

public abstract class AbstractPerspective {
    @Inject
    protected UberfireDocks uberfireDocks;
    protected UberfireDock basicFiltersDock;
    protected UberfireDock advancedFiltersDock;
    protected UberfireDock savedFiltersDock;
    private PlaceRequest placeRequest;

    @PostConstruct
    protected void init() {
        this.placeRequest = this.getPlaceRequest();
        this.setupDocks();
    }

    @Perspective
    public PerspectiveDefinition getPerspective() {
        PerspectiveDefinitionImpl p = new PerspectiveDefinitionImpl(MultiScreenWorkbenchPanelPresenter.class.getName());
        p.setName(this.getPerspectiveId());
        p.getRoot().addPart((PartDefinition)new PartDefinitionImpl(this.placeRequest));
        return p;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.placeRequest.getParameters().clear();
        for (String param : place.getParameterNames()) {
            this.placeRequest.addParameter(param, place.getParameter(param, null));
        }
    }

    @OnOpen
    public void onOpen() {
        if (this.basicFiltersDock != null) {
            Scheduler.get().scheduleDeferred(() -> {
                this.uberfireDocks.show(UberfireDockPosition.WEST, this.getPerspectiveId());
                this.uberfireDocks.open(this.basicFiltersDock);
            });
        }
    }

    public void onDetailsOpen(@Observes SelectPlaceEvent event) {
        if (event.getPlace().getIdentifier().equals(this.getDetailsScreenId())) {
            this.uberfireDocks.hide(UberfireDockPosition.WEST, this.getPerspectiveId());
        }
    }

    public void onDetailsClose(@Observes ClosePlaceEvent event) {
        if (event.getPlace().getIdentifier().equals(this.getDetailsScreenId())) {
            this.uberfireDocks.show(UberfireDockPosition.WEST, this.getPerspectiveId());
        }
        if (event.getPlace().getIdentifier().equals(this.getAdvancedFiltersScreenId())) {
            this.uberfireDocks.close(this.advancedFiltersDock);
        }
    }

    protected void setupDocks() {
        String savedFiltersScreenId;
        String advancedFiltersScreenId;
        String basicFiltersScreenId = this.getBasicFiltersScreenId();
        if (basicFiltersScreenId != null) {
            this.basicFiltersDock = new UberfireDock(UberfireDockPosition.WEST, IconType.FILTER.toString(), (PlaceRequest)new DefaultPlaceRequest(basicFiltersScreenId), this.getPerspectiveId()).withSize(400.0).withLabel(Constants.INSTANCE.Filters());
            this.uberfireDocks.add(new UberfireDock[]{this.basicFiltersDock});
        }
        if ((advancedFiltersScreenId = this.getAdvancedFiltersScreenId()) != null) {
            this.advancedFiltersDock = new UberfireDock(UberfireDockPosition.WEST, IconType.PLUS_SQUARE_O.toString(), (PlaceRequest)new DefaultPlaceRequest(advancedFiltersScreenId), this.getPerspectiveId()).withSize(500.0).withLabel(Constants.INSTANCE.AdvancedFilters());
            this.uberfireDocks.add(new UberfireDock[]{this.advancedFiltersDock});
        }
        if ((savedFiltersScreenId = this.getSavedFiltersScreenId()) != null) {
            this.savedFiltersDock = new UberfireDock(UberfireDockPosition.WEST, IconType.STAR_O.toString(), (PlaceRequest)new DefaultPlaceRequest(savedFiltersScreenId), this.getPerspectiveId()).withSize(400.0).withLabel(Constants.INSTANCE.SavedFilters());
            this.uberfireDocks.add(new UberfireDock[]{this.savedFiltersDock});
        }
    }

    public abstract String getPerspectiveId();

    public abstract String getBasicFiltersScreenId();

    public abstract String getAdvancedFiltersScreenId();

    public abstract String getSavedFiltersScreenId();

    public abstract String getDetailsScreenId();

    public abstract PlaceRequest getPlaceRequest();
}

