/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.common.collect.FluentIterable;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.jbpm.workbench.ks.events.KieServerDataSetRegistered;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class ServerTemplateSelectorMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    @Inject
    private ServerTemplateSelectorWidgetView widgetView;
    @Inject
    private ServerTemplateSelectorElementView view;
    @Inject
    private Caller<SpecManagementService> specManagementService;
    @Inject
    private Event<ServerTemplateSelected> serverTemplateSelectedEvent;
    private Map<String, ServerTemplate> serverTemplateMap = new HashMap<String, ServerTemplate>();

    @PostConstruct
    public void init() {
        this.widgetView.setServerTemplateChangeHandler((ParameterizedCommand<String>)((ParameterizedCommand)e -> {
            this.view.updateSelectedValue((String)e);
            this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(this.serverTemplateMap.get(e)));
        }));
        this.view.setServerTemplateChangeHandler((ParameterizedCommand<String>)((ParameterizedCommand)e -> {
            this.widgetView.updateSelectedValue((String)e);
            this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(this.serverTemplateMap.get(e)));
        }));
        this.loadServerTemplates();
    }

    protected void loadServerTemplates() {
        this.serverTemplateMap.clear();
        this.widgetView.removeAllServerTemplates();
        this.view.removeAllServerTemplates();
        ((SpecManagementService)this.specManagementService.call(serverTemplates -> {
            FluentIterable.from((Object[])serverTemplates.getServerTemplates()).filter(s -> s.getServerInstanceKeys() != null && !s.getServerInstanceKeys().isEmpty()).forEach(s -> this.serverTemplateMap.put(s.getId(), (ServerTemplate)s));
            List ids = this.serverTemplateMap.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
            for (String id : ids) {
                this.widgetView.addServerTemplate(id);
                this.view.addServerTemplate(id);
            }
            if (ids.size() == 1) {
                this.widgetView.selectServerTemplate((String)ids.iterator().next());
                this.view.selectServerTemplate((String)ids.iterator().next());
            } else {
                ServerTemplate selectedServerTemplate = this.getSelectedServerTemplate();
                if (selectedServerTemplate != null && ids.contains(selectedServerTemplate.getId())) {
                    this.widgetView.selectServerTemplate(selectedServerTemplate.getId());
                    this.view.selectServerTemplate(selectedServerTemplate.getId());
                } else {
                    this.widgetView.clearSelectedServerTemplate();
                    this.view.clearSelectedServerTemplate();
                    if (ids.size() > 1) {
                        String defaultServerTemplate = (String)ids.get(0);
                        this.widgetView.selectServerTemplate(defaultServerTemplate);
                        this.view.selectServerTemplate(defaultServerTemplate);
                    }
                }
            }
            this.widgetView.setVisible(ids.size() > 1);
            this.view.setVisible(ids.size() > 1);
        })).listServerTemplates();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return ServerTemplateSelectorMenuBuilder.this.widgetView;
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean enabled) {
            }
        };
    }

    public ServerTemplateSelectorElementView getView() {
        return this.view;
    }

    public void onServerTemplateDeleted(@Observes ServerTemplateDeleted serverTemplateDeleted) {
        this.loadServerTemplates();
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        if (serverTemplateUpdated.getServerTemplate().getServerInstanceKeys().isEmpty()) {
            this.loadServerTemplates();
        }
    }

    public void onKieServerDataSetRegistered(@Observes KieServerDataSetRegistered kieServerDataSetRegistered) {
        this.loadServerTemplates();
    }

    @Inject
    public void setSpecManagementService(Caller<SpecManagementService> specManagementService) {
        this.specManagementService = specManagementService;
    }

    public ServerTemplate getSelectedServerTemplate() {
        return this.serverTemplateMap.get(this.view.getSelectedServerTemplate());
    }

    public String getSelectedServerTemplateId() {
        ServerTemplate serverTemplate = this.getSelectedServerTemplate();
        return serverTemplate == null ? "" : serverTemplate.getId();
    }

    public static interface ServerTemplateSelectorElementView
    extends ServerTemplateSelectorView,
    UberElement<ServerTemplateSelectorMenuBuilder> {
    }

    public static interface ServerTemplateSelectorWidgetView
    extends ServerTemplateSelectorView,
    IsWidget {
    }

    public static interface ServerTemplateSelectorView {
        public void selectServerTemplate(String var1);

        public void updateSelectedValue(String var1);

        public void setVisible(boolean var1);

        public void clearSelectedServerTemplate();

        public String getSelectedServerTemplate();

        public void addServerTemplate(String var1);

        public void removeAllServerTemplates();

        public void setServerTemplateChangeHandler(ParameterizedCommand<String> var1);
    }
}

