/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.HTMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.menu.ManageSelector;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class ManageSelectorImpl
implements ManageSelector {
    private static final Map<String, String> availablePerspectives;
    @Inject
    ManageSelectorView view;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private PerspectiveManager perspectiveManager;
    @Inject
    private User identity;
    @Inject
    private PlaceManager placeManager;

    @PostConstruct
    public void init() {
        this.view.removeAllOptions();
        String currentPerspectiveId = this.perspectiveManager.getCurrentPerspective().getIdentifier();
        availablePerspectives.keySet().forEach(perspectiveId -> this.addPerspective((String)perspectiveId, availablePerspectives.get(perspectiveId), perspectiveId.equals(currentPerspectiveId)));
        this.view.setOptionChangeCommand(() -> this.goToPerspective(this.view.getSelectedOption()));
        this.view.refresh();
    }

    private boolean hasAccessToPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }

    protected void addPerspective(String perspectiveId, String optionLabel, boolean selected) {
        if (this.hasAccessToPerspective(perspectiveId) && !this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest(perspectiveId)).isEmpty()) {
            this.view.addOption(optionLabel, perspectiveId, selected);
        }
    }

    public void goToPerspective(String perspectiveId) {
        if (perspectiveId != null && !perspectiveId.isEmpty()) {
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(perspectiveId));
        }
    }

    @Override
    public IsWidget getManageSelectorWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    static {
        HashMap<String, String> perspectives = new HashMap<String, String>();
        perspectives.put("ProcessDefinitions", Constants.INSTANCE.Process_Definitions());
        perspectives.put("ProcessInstances", Constants.INSTANCE.Process_Instances());
        perspectives.put("TaskAdmin", Constants.INSTANCE.Tasks());
        perspectives.put("ExecutionErrors", Constants.INSTANCE.ExecutionErrors());
        perspectives.put("Requests", Constants.INSTANCE.Jobs());
        availablePerspectives = Collections.unmodifiableMap(perspectives);
    }

    public static interface ManageSelectorView
    extends IsElement {
        public void addOption(String var1, String var2, boolean var3);

        public void removeAllOptions();

        public void setOptionChangeCommand(Command var1);

        public void refresh();

        public String getSelectedOption();
    }
}

