/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.KebabMenu;
import org.uberfire.client.views.pfly.widgets.KebabMenuItem;

@Dependent
public class ConditionalKebabActionCell<T extends GenericSummary>
extends AbstractCell<T> {
    private List<ConditionalAction<T>> actions;
    @Inject
    private HTMLDocument document;
    @Inject
    private ManagedInstance<KebabMenu> kebabMenus;
    @Inject
    private ManagedInstance<KebabMenuItem> kebabMenuItems;
    @Inject
    private ManagedInstance<Button> buttons;

    public ConditionalKebabActionCell() {
        super(new String[]{"click", "keydown"});
    }

    public void setActions(List<ConditionalAction<T>> actions) {
        this.actions = actions;
    }

    private String getHTMLContent(Element element) {
        HTMLDivElement div = (HTMLDivElement)this.document.createElement("div");
        div.appendChild((Node)element);
        return div.innerHTML;
    }

    public void render(Cell.Context context, T value, SafeHtmlBuilder sb) {
        List availableActions = this.actions.stream().filter(a -> a.getPredicate().test((GenericSummary)value)).collect(Collectors.toList());
        if (availableActions.isEmpty()) {
            return;
        }
        if (availableActions.size() > 1) {
            KebabMenu menu = (KebabMenu)this.kebabMenus.get();
            menu.setItemsAlignment(KebabMenu.ItemsAlignment.RIGHT);
            menu.setDropPosition(KebabMenu.DropPosition.UP);
            menu.getElement().id = Document.get().createUniqueId();
            List<ConditionalAction> actionMenus = availableActions.stream().filter(action -> action.isNavigation() == false).collect(Collectors.toList());
            actionMenus.forEach(action -> this.addKebabMenuItem(menu, value, action.getText(), action.getCallback()));
            List<ConditionalAction> navigationMenus = availableActions.stream().filter(action -> action.isNavigation()).collect(Collectors.toList());
            if (!actionMenus.isEmpty() && !navigationMenus.isEmpty()) {
                menu.addSeparator();
            }
            navigationMenus.forEach(action -> this.addKebabMenuItem(menu, value, action.getText(), action.getCallback()));
            sb.appendHtmlConstant(this.getHTMLContent((Element)menu.getElement()));
            this.fixOpenPosition(menu.getElement().id);
        } else {
            Button button = (Button)this.buttons.get();
            button.setType(Button.ButtonType.BUTTON);
            button.setButtonStyleType(Button.ButtonStyleType.DEFAULT);
            button.setText(((ConditionalAction)availableActions.get(0)).getText());
            button.getElement().id = Document.get().createUniqueId();
            this.setCallback(button.getElement().id, value, ((ConditionalAction)availableActions.get(0)).getCallback());
            sb.appendHtmlConstant(this.getHTMLContent((Element)button.getElement()));
        }
    }

    private void addKebabMenuItem(KebabMenu menu, T value, String label, Consumer<T> callback) {
        KebabMenuItem menuItem = (KebabMenuItem)this.kebabMenuItems.get();
        menuItem.setText(label);
        menuItem.getElement().id = Document.get().createUniqueId();
        this.setCallback(menuItem.getElement().id, value, callback);
        menu.addKebabItem((HTMLLIElement)menuItem.getElement());
    }

    public void fixOpenPosition(String id) {
        Scheduler.get().scheduleDeferred(() -> this.fixKebabMenuOpenPosition(id));
    }

    public void setCallback(String id, T value, Consumer<T> callback) {
        Scheduler.get().scheduleDeferred(() -> {
            Element elementById = this.document.getElementById(id);
            if (elementById != null) {
                elementById.addEventListener("click", e -> callback.accept(value));
            }
        });
    }

    private native void fixKebabMenuOpenPosition(String var1);
}

