/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import java.util.Collections;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.mocks.EventSourceMock;

public abstract class AbstractBasicFiltersPresenterTest {
    @Mock
    BasicFiltersView view;
    @Spy
    Event<BasicFilterAddEvent> activeFilters = new EventSourceMock();
    @Spy
    Event<BasicFilterRemoveEvent> basicFilterRemoveEvent = new EventSourceMock();

    public abstract BasicFiltersPresenter getPresenter();

    public BasicFiltersView getView() {
        return this.view;
    }

    @Before
    public void init() {
        ((Event)Mockito.doNothing().when(this.activeFilters)).fire((Object)((BasicFilterAddEvent)Matchers.any()));
        ((Event)Mockito.doNothing().when(this.basicFilterRemoveEvent)).fire((Object)((BasicFilterRemoveEvent)Matchers.any()));
    }

    @Test
    public void testSearchFilterListEmpty() {
        this.getPresenter().addSearchFilterList("columnId", new ActiveFilterItem(null, null, null, Collections.emptyList(), null));
        ((Event)Mockito.verify(this.basicFilterRemoveEvent)).fire((Object)((BasicFilterRemoveEvent)Matchers.any()));
    }

    @Test
    public void testSearchFilterList() {
        this.getPresenter().addSearchFilterList("columnId", new ActiveFilterItem(null, null, null, Collections.singletonList("value"), null));
        ((Event)Mockito.verify(this.activeFilters)).fire((Object)((BasicFilterAddEvent)Matchers.any()));
    }

    @Test
    public void testAddSearchFilter() {
        CoreFunctionFilter testColumnFilter = (CoreFunctionFilter)Mockito.mock(CoreFunctionFilter.class);
        ActiveFilterItem activeFilterItem = new ActiveFilterItem("test_key", "test_lable", null, null, null);
        this.getPresenter().addSearchFilter(activeFilterItem, (ColumnFilter)testColumnFilter);
        ((CoreFunctionFilter)Mockito.verify((Object)testColumnFilter)).setLabelValue("test_lable");
        ((Event)Mockito.verify(this.activeFilters)).fire((Object)((BasicFilterAddEvent)Matchers.any()));
    }

    public abstract void testLoadFilters();
}

