/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.gwt.dev.util.collect.Sets;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.menu.ManageSelectorImpl;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ManageSelectorImplTest {
    private String selected_Perspective = "ProcessDefinitions";
    @InjectMocks
    ManageSelectorImpl manageSelector;
    @Mock
    ManageSelectorImpl.ManageSelectorView view;
    @Mock
    PerspectiveManager perspectiveManagerMock;
    @Mock
    PerspectiveActivity perspectiveActivityMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private ActivityManager activityManagerMock;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;

    @Before
    public void setup() {
        Mockito.when((Object)this.perspectiveActivityMock.getIdentifier()).thenReturn((Object)this.selected_Perspective);
        Mockito.when((Object)this.perspectiveManagerMock.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivityMock);
        Mockito.when((Object)this.view.getSelectedOption()).thenReturn((Object)this.selected_Perspective);
        Mockito.when((Object)this.activityManagerMock.getActivities((PlaceRequest)Mockito.any(DefaultPlaceRequest.class))).thenReturn((Object)Sets.create((Object)((Activity)Mockito.mock(Activity.class))));
    }

    @Test
    public void testInitManageSelector_AllPerspectivesGranted() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        this.manageSelector.init();
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).removeAllOptions();
        this.verifyInitSelectorBasicViewInteractions();
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).addOption(Constants.INSTANCE.Process_Definitions(), "ProcessDefinitions", true);
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).addOption(Constants.INSTANCE.Process_Instances(), "ProcessInstances", false);
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).addOption(Constants.INSTANCE.Tasks(), "TaskAdmin", false);
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).addOption(Constants.INSTANCE.ExecutionErrors(), "ExecutionErrors", false);
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).addOption(Constants.INSTANCE.Jobs(), "Requests", false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testInitManageSelector_NotAllPerspectivesGranted() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{true, false, false, false});
        this.manageSelector.init();
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).removeAllOptions();
        this.verifyInitSelectorBasicViewInteractions();
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addOption(Mockito.anyString(), Mockito.anyString(), Mockito.anyBoolean());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    private void verifyInitSelectorBasicViewInteractions() {
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).setOptionChangeCommand((Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).getSelectedOption();
        ArgumentCaptor captureDefaultPlaceRequest = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock)).goTo((PlaceRequest)captureDefaultPlaceRequest.capture());
        Assert.assertEquals((Object)this.selected_Perspective, (Object)((DefaultPlaceRequest)captureDefaultPlaceRequest.getValue()).getIdentifier());
        ((ManageSelectorImpl.ManageSelectorView)Mockito.verify((Object)this.view)).refresh();
    }
}

