/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.active;

import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemRemovedEvent;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemView;
import org.jbpm.workbench.common.client.filters.active.ActiveFiltersView;
import org.jbpm.workbench.common.client.filters.active.SaveFilterPopoverView;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@Dependent
public class ActiveFiltersViewImpl
implements ActiveFiltersView {
    @Inject
    @DataField(value="remove-all-filters")
    HTMLAnchorElement removeAll;
    @Inject
    @DataField(value="save-filter")
    Anchor saveFilter;
    @Inject
    @DataField(value="content")
    HTMLDivElement content;
    @Inject
    @DataField(value="active-filters")
    @ListContainer(value="ul")
    @Bound
    private ListComponent<ActiveFilterItem, ActiveFilterItemView> activeFilters;
    @Inject
    @AutoBound
    private DataBinder<List<ActiveFilterItem>> activeFiltersList;
    @Inject
    private JQueryProducer.JQuery<Popover> jQueryPopover;
    @Inject
    private SaveFilterPopoverView saveFilterPopoverView;
    private Popover saveFilterPopover;
    private ParameterizedCommand<String> saveFilterCallback;
    private Command removeAllFilterCallback;

    @PostConstruct
    public void init() {
        this.saveFilterPopover = (Popover)this.jQueryPopover.wrap((Element)this.saveFilter);
        this.setSaveFilterPopoverCallback();
        this.activeFiltersList.setModel(new ArrayList());
        this.activeFilters.addComponentCreationHandler(v -> {
            this.saveFilter.getClassList().remove("disabled");
            this.removeAll.classList.remove(new String[]{"disabled"});
            PopoverOptions popoverOptions = new PopoverOptions();
            popoverOptions.setContent(e -> this.saveFilterPopoverView.getElement());
            this.saveFilterPopover.popover(popoverOptions);
            this.saveFilterPopover.addShowListener(() -> this.saveFilterPopoverView.onOpen());
            this.saveFilterPopover.addShownListener(() -> this.saveFilterPopoverView.onShow());
        });
        this.activeFilters.addComponentDestructionHandler(v -> {
            Consumer callback;
            if (((List)this.activeFiltersList.getModel()).isEmpty()) {
                this.saveFilter.getClassList().add("disabled");
                this.removeAll.classList.add(new String[]{"disabled"});
                this.saveFilterPopover.destroy();
            }
            if ((callback = v.getValue().getCallback()) != null) {
                callback.accept(v.getValue().getValue());
            }
        });
    }

    protected void setSaveFilterPopoverCallback() {
        this.saveFilterPopoverView.setCancelCallback(() -> this.closeSaveFilter());
        this.saveFilterPopoverView.setSaveCallback((ParameterizedCommand<String>)((ParameterizedCommand)name -> this.saveFilter((String)name)));
    }

    @PreDestroy
    public void destroy() {
        this.saveFilterPopover.destroy();
    }

    @Override
    public void setSaveFilterCallback(ParameterizedCommand<String> callback) {
        this.saveFilterCallback = callback;
    }

    @Override
    public void setRemoveAllFilterCallback(Command callback) {
        this.removeAllFilterCallback = callback;
    }

    @Override
    public void closeSaveFilter() {
        this.saveFilterPopover.hide();
    }

    @Override
    public void setSaveFilterErrorMessage(String message) {
        this.saveFilterPopoverView.setError(message);
    }

    protected void saveFilter(String filterName) {
        if (this.saveFilterCallback != null) {
            this.saveFilterCallback.execute((Object)filterName);
        }
    }

    @Override
    public <T> void addActiveFilter(ActiveFilterItem<T> filter) {
        ((List)this.activeFiltersList.getModel()).removeIf(f -> f.getKey().equals(filter.getKey()));
        ((List)this.activeFiltersList.getModel()).add(filter);
    }

    public void onRemoveActiveFilter(@Observes ActiveFilterItemRemovedEvent event) {
        ((List)this.activeFiltersList.getModel()).remove(event.getActiveFilterItem());
    }

    @Override
    public <T> void removeActiveFilter(ActiveFilterItem<T> filter) {
        ((List)this.activeFiltersList.getModel()).removeIf(f -> f.getKey().equals(filter.getKey()));
    }

    @EventHandler(value={"remove-all-filters"})
    public void onRemoveAll(@ForEvent(value={"click"}) Event e) {
        if (!((List)this.activeFiltersList.getModel()).isEmpty() && this.removeAllFilterCallback != null) {
            this.removeAllFilterCallback.execute();
        }
    }

    @EventHandler(value={"save-filter"})
    public void onSaveFilter(@ForEvent(value={"click"}) Event e) {
        this.saveFilterPopover.toggle();
    }

    @Override
    public void removeAllActiveFilters(Boolean useCallback) {
        if (!useCallback.booleanValue()) {
            ((List)this.activeFiltersList.getModel()).forEach(f -> f.setCallback(null));
        }
        Iterator iterator = ((List)this.activeFiltersList.getModel()).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public HTMLElement getElement() {
        return this.content;
    }
}

