/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.model.GenericSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.DataGrid;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExtendedPagedTableTest {
    @Mock
    GridGlobalPreferences preferences;
    @Mock
    DataGrid dataGrid;
    ExtendedPagedTable table;

    @Before
    public void setup() {
        this.table = new ExtendedPagedTable(this.preferences);
        this.table.dataGrid = this.dataGrid;
    }

    @Test
    public void testHasSelectedItems() {
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.table.hasSelectedItems());
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Arrays.asList(gs, gs));
        this.table.setItemSelection(gs, Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.table.hasSelectedItems());
    }

    @Test
    public void testDeselectAllItems() {
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(Arrays.asList(gs, gs));
        this.table.deselectAllItems();
        Assert.assertTrue((boolean)this.table.getSelectedItems().isEmpty());
    }

    @Test
    public void testSelectAllItems() {
        this.testSelectAll(0);
    }

    @Test
    public void testSelectAllItemsFromNextPage() {
        this.testSelectAll(5);
    }

    protected void testSelectAll(int offset) {
        Column column = (Column)Mockito.mock(Column.class);
        FieldUpdater updater = (FieldUpdater)Mockito.mock(FieldUpdater.class);
        Mockito.when((Object)column.getFieldUpdater()).thenReturn((Object)updater);
        Mockito.when((Object)this.dataGrid.getColumn(0)).thenReturn((Object)column);
        Mockito.when((Object)this.table.pager.getPageStart()).thenReturn((Object)offset);
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        Mockito.when((Object)this.dataGrid.getVisibleItem(0)).thenReturn((Object)gs);
        Mockito.when((Object)this.dataGrid.getVisibleItem(1)).thenReturn((Object)gs);
        Mockito.when((Object)this.dataGrid.getVisibleItemCount()).thenReturn((Object)2);
        this.table.selectAllItems();
        ((FieldUpdater)Mockito.verify((Object)updater)).update(offset + 0, (Object)gs, (Object)true);
        ((FieldUpdater)Mockito.verify((Object)updater)).update(offset + 1, (Object)gs, (Object)true);
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).redrawRow(offset + 0);
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).redrawRow(offset + 1);
    }

    @Test
    public void setItemSelectedSelectionTest() {
        GenericSummary gs_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        ArrayList<GenericSummary> selectedItems = new ArrayList<GenericSummary>();
        selectedItems.add(gs_selected);
        this.table.setSelectedItems(selectedItems);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_selected, Boolean.valueOf(true));
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_selected, Boolean.valueOf(false));
        this.checkSelectedItemsContent(0, new GenericSummary[0]);
    }

    @Test
    public void setItemNotSelectedSelectionTest() {
        GenericSummary gs_selected = (GenericSummary)Mockito.mock(GenericSummary.class);
        GenericSummary gs_new_selection = (GenericSummary)Mockito.mock(GenericSummary.class);
        ArrayList<GenericSummary> selectedItems = new ArrayList<GenericSummary>();
        selectedItems.add(gs_selected);
        this.table.setSelectedItems(selectedItems);
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
        this.table.setItemSelection(gs_new_selection, Boolean.valueOf(true));
        this.checkSelectedItemsContent(2, (GenericSummary)this.table.getSelectedItems().get(0), (GenericSummary)this.table.getSelectedItems().get(1));
        this.table.setItemSelection(gs_new_selection, Boolean.valueOf(false));
        this.checkSelectedItemsContent(1, (GenericSummary)this.table.getSelectedItems().get(0));
    }

    private void checkSelectedItemsContent(int size, GenericSummary ... genericSummary) {
        Assert.assertEquals((long)size, (long)this.table.getSelectedItems().size());
        for (int i = 0; i < genericSummary.length; ++i) {
            Assert.assertEquals((Object)genericSummary[i], this.table.getSelectedItems().get(i));
        }
    }

    @Test
    public void testIsAllItemsSelected() {
        GenericSummary gs = (GenericSummary)Mockito.mock(GenericSummary.class);
        List list1 = Collections.emptyList();
        List<GenericSummary> list2 = Arrays.asList(gs, gs);
        List<GenericSummary> list3 = Collections.singletonList(gs);
        Mockito.when((Object)this.dataGrid.getVisibleItemCount()).thenReturn((Object)list1.size(), (Object[])new Integer[]{list2.size(), list3.size()});
        Mockito.when((Object)this.dataGrid.getVisibleItems()).thenReturn(list2, (Object[])new List[]{list3});
        Assert.assertFalse((boolean)this.table.isAllItemsSelected());
        this.table.setItemSelection(gs, Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.table.isAllItemsSelected());
        this.table.setItemSelection(gs, Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.table.isAllItemsSelected());
    }
}

