/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateTimeNAConverter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateTimeNAConverterTest {
    @InjectMocks
    private DateTimeNAConverter converter;

    @Test
    public void testToModelValue() {
        Date date = this.converter.toModelValue("28/06/2017 13:51");
        Assert.assertEquals((long)117L, (long)date.getYear());
        Assert.assertEquals((long)5L, (long)date.getMonth());
        Assert.assertEquals((long)28L, (long)date.getDate());
        Assert.assertEquals((long)13L, (long)date.getHours());
        Assert.assertEquals((long)51L, (long)date.getMinutes());
    }

    @Test
    public void testToWidgetValue() {
        Date date = new Date();
        String dateStr = this.converter.toWidgetValue(date);
        String expected = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(date);
        Assert.assertEquals((Object)expected, (Object)dateStr);
    }

    @Test
    public void testToWidgetValueEmpty() {
        String dateStr = this.converter.toWidgetValue(null);
        Assert.assertEquals((Object)Constants.INSTANCE.NA(), (Object)dateStr);
    }
}

