/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersViewImpl;
import org.jbpm.workbench.common.client.util.DateRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Moment;

@RunWith(value=GwtMockitoTestRunner.class)
public class BasicFiltersViewImplTest {
    @Mock
    TranslationService translationService;
    @InjectMocks
    BasicFiltersViewImpl view;

    @Test
    public void testDateRangeChange() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        String label = "label";
        String selectedLabel = "selectedLabel";
        Moment startMoment = (Moment)Mockito.mock(Moment.class);
        Mockito.when((Object)startMoment.milliseconds(Matchers.anyInt())).thenReturn((Object)startMoment);
        Date startDate = new Date();
        Mockito.when((Object)startMoment.asDate()).thenReturn((Object)startDate);
        Moment endMoment = (Moment)Mockito.mock(Moment.class);
        Mockito.when((Object)endMoment.milliseconds(Matchers.anyInt())).thenReturn((Object)endMoment);
        Date endDate = new Date();
        Mockito.when((Object)endMoment.asDate()).thenReturn((Object)endDate);
        this.view.onDateRangeValueChange("label", "selectedLabel", startMoment, endMoment, callback);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((Consumer)Mockito.verify((Object)callback)).accept((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"label", (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)"label: selectedLabel", (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)startDate, (Object)((DateRange)((ActiveFilterItem)captor.getValue()).getValue()).getStartDate());
        Assert.assertEquals((Object)endDate, (Object)((DateRange)((ActiveFilterItem)captor.getValue()).getValue()).getEndDate());
    }

    @Test
    public void testAddActiveFilter() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        String labelKey = "key1";
        String labelValue = "someValue";
        String hint = "hint";
        Integer value = 1;
        this.view.addActiveFilter("key1", "someValue", "hint", (Object)value, callback);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((Consumer)Mockito.verify((Object)callback)).accept((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        ActiveFilterItem filterItem = (ActiveFilterItem)captor.getValue();
        Assert.assertEquals((Object)"key1", (Object)filterItem.getKey());
        Assert.assertEquals((Object)"key1: someValue", (Object)filterItem.getLabelValue());
        Assert.assertEquals((Object)"hint", (Object)filterItem.getHint());
        Assert.assertEquals((Object)value, (Object)filterItem.getValue());
    }

    @Test
    public void testClearAllSelectFilter() {
        Input input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)input.getChecked()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.view.getSelectInputs().put("label", Arrays.asList(input, input));
        this.view.clearAllSelectFilter();
        ((Input)Mockito.verify((Object)input)).setChecked(false);
        ((Input)Mockito.verify((Object)input, (VerificationMode)Mockito.times((int)2))).getChecked();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{input});
    }

    @Test
    public void testClearSelectFilter() {
        Input input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)input.getChecked()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.view.getSelectInputs().put("label1", Arrays.asList(input, input));
        this.view.getSelectInputs().put("label2", Arrays.asList(input, input));
        this.view.clearSelectFilter("label1");
        this.view.clearSelectFilter("label3");
        ((Input)Mockito.verify((Object)input)).setChecked(false);
        ((Input)Mockito.verify((Object)input, (VerificationMode)Mockito.times((int)2))).getChecked();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{input});
    }

    @Test
    public void testCheckSelectFilter() {
        Input input1 = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)input1.getChecked()).thenReturn((Object)true);
        Mockito.when((Object)input1.getValue()).thenReturn((Object)"1");
        Input input2 = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)input2.getChecked()).thenReturn((Object)false);
        Mockito.when((Object)input2.getValue()).thenReturn((Object)"2");
        this.view.getSelectInputs().put("label1", Arrays.asList(input1, input2));
        this.view.checkSelectFilter("label1", "1");
        this.view.checkSelectFilter("label1", "2");
        ((Input)Mockito.verify((Object)input1, (VerificationMode)Mockito.never())).setChecked(true);
        ((Input)Mockito.verify((Object)input2)).setChecked(true);
    }
}

