/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.active;

import elemental2.dom.HTMLElement;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilters;
import org.jbpm.workbench.common.client.filters.active.ActiveFiltersView;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ActiveFiltersImpl
implements ActiveFilters {
    @Inject
    ActiveFiltersView view;
    @Inject
    Event<ClearAllActiveFiltersEvent> clearAllActiveFiltersEvent;
    private BiConsumer<String, Consumer<String>> filterNameCallback;

    @PostConstruct
    public void init() {
        this.view.setSaveFilterCallback((ParameterizedCommand<String>)((ParameterizedCommand)name -> {
            if (this.filterNameCallback != null) {
                this.filterNameCallback.accept((String)name, error -> {
                    if (error == null) {
                        this.view.closeSaveFilter();
                    } else {
                        this.view.setSaveFilterErrorMessage((String)error);
                    }
                });
            }
        }));
        this.view.setRemoveAllFilterCallback(() -> {
            this.view.removeAllActiveFilters(true);
            this.clearAllActiveFiltersEvent.fire((Object)new ClearAllActiveFiltersEvent());
        });
    }

    @Override
    public void setSaveFilterCallback(BiConsumer<String, Consumer<String>> filterNameCallback) {
        this.filterNameCallback = filterNameCallback;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public <T> void addActiveFilter(ActiveFilterItem<T> filter) {
        this.view.addActiveFilter(filter);
    }

    @Override
    public <T> void removeActiveFilter(ActiveFilterItem<T> filter) {
        this.view.removeActiveFilter(filter);
    }

    @Override
    public void removeAllActiveFilters() {
        this.view.removeAllActiveFilters(false);
        this.clearAllActiveFiltersEvent.fire((Object)new ClearAllActiveFiltersEvent());
    }
}

