/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.common.client.api.IsElement;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemRemovedEvent;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.filter.FilterEditorPopup;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.lifecycle.OnOpen;

public abstract class BasicFiltersPresenter {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    protected BasicFiltersView view;
    protected FilterSettingsManager filterSettingsManager;
    @Inject
    protected Event<BasicFilterAddEvent> basicFilterAddEvent;
    @Inject
    protected Event<BasicFilterRemoveEvent> basicFilterRemoveEvent;
    @Inject
    private FilterEditorPopup filterEditorPopup;
    @Inject
    private Event<SavedFilterSelectedEvent> savedFilterSelectedEvent;

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Filters();
    }

    @PostConstruct
    public void init() {
        this.view.setAdvancedFiltersCallback(() -> this.showAdvancedFilters());
        this.loadFilters();
    }

    @OnOpen
    public void onOpen() {
        this.view.clearAllSelectFilter();
    }

    public void onClearAllActiveFiltersEvent(@Observes ClearAllActiveFiltersEvent event) {
        this.view.clearAllSelectFilter();
    }

    public abstract void loadFilters();

    public void setFilterSettingsManager(FilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    protected void addSearchFilter(ActiveFilterItem filter, ColumnFilter columnFilter) {
        this.basicFilterAddEvent.fire((Object)new BasicFilterAddEvent(filter, columnFilter));
    }

    protected void addSearchFilterList(String columnId, ActiveFilterItem<List<String>> filter, Integer size) {
        ColumnFilter columnFilter = FilterFactory.in((String)columnId, filter.getValue());
        if (filter.getValue().isEmpty() || filter.getValue().size() == size.intValue()) {
            this.removeSearchFilter(filter, columnFilter);
        } else {
            this.addSearchFilter(filter, columnFilter);
        }
    }

    protected void removeSearchFilter(ActiveFilterItem filter, ColumnFilter columnFilter) {
        this.basicFilterRemoveEvent.fire((Object)new BasicFilterRemoveEvent(filter, columnFilter));
    }

    protected void showAdvancedFilters() {
        this.filterEditorPopup.setTitle(this.getAdvancedFilterPopupTitle());
        this.filterEditorPopup.show(this.filterSettingsManager.createFilterSettingsPrototype(), filterSettings -> this.filterSettingsManager.saveFilterIntoPreferences(filterSettings, state -> {
            if (state.booleanValue()) {
                this.filterEditorPopup.hide();
                this.savedFilterSelectedEvent.fire((Object)new SavedFilterSelectedEvent(new SavedFilter(filterSettings.getKey(), filterSettings.getTableName())));
            } else {
                this.filterEditorPopup.setTableNameError(Constants.INSTANCE.FilterWithSameNameAlreadyExists());
            }
        }));
    }

    protected abstract String getAdvancedFilterPopupTitle();

    public void onRemoveActiveFilter(@Observes ActiveFilterItemRemovedEvent event) {
        this.view.clearSelectFilter(event.getActiveFilterItem().getKey());
    }

    protected void onSavedFilterSelectedEvent(@Observes SavedFilterSelectedEvent event) {
        this.view.clearAllSelectFilter();
    }
}

