/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.common.collect.Iterables;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilters;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractMultiGridPresenter>
extends Composite
implements MultiGridView<T, V> {
    public static final String COL_ID_SELECT = "Select";
    public static final String COL_ID_ACTIONS = "Actions";
    public static final int ACTIONS_COLUMN_WIDTH = 120;
    public static final int CHECK_COLUMN_WIDTH = 38;
    public static final int ERROR_COLUMN_WIDTH = 65;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;
    @Inject
    protected PlaceManager placeManager;
    protected Caller<UserPreferencesService> userPreferencesService;
    protected ListTable<T> listTable;
    protected V presenter;
    @Inject
    @DataField(value="column")
    protected HTMLDivElement column;
    @Inject
    @DataField(value="active-filters")
    protected ActiveFilters filters;

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void init(V presenter) {
        this.presenter = presenter;
    }

    protected void controlBulkOperations(ListTable<T> extendedPagedTable) {
        this.enableWidgets((Widget)Iterables.getFirst((Iterable)extendedPagedTable.getRightActionsToolbar(), null), extendedPagedTable.hasSelectedItems());
    }

    protected void enableWidgets(Widget widget, boolean enable) {
        if (widget == null) {
            return;
        }
        if (widget instanceof HasEnabled) {
            ((HasEnabled)widget).setEnabled(enable);
        }
        if (widget instanceof HasWidgets) {
            for (Widget w : (HasWidgets)widget) {
                this.enableWidgets(w, enable);
            }
        }
    }

    @Override
    public void loadListTable(String key, Consumer<ListTable<T>> readyCallback) {
        GridGlobalPreferences pref = new GridGlobalPreferences(key, this.getInitColumns(), this.getBannedColumns());
        ListTable newListGrid = new ListTable(pref);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        newListGrid.setPreferencesService(this.userPreferencesService);
        ((UserPreferencesService)this.userPreferencesService.call(preferencesStore -> {
            if (preferencesStore == null) {
                newListGrid.setGridPreferencesStore(new GridPreferencesStore(pref));
            } else {
                newListGrid.setGridPreferencesStore((GridPreferencesStore)preferencesStore);
            }
            this.initColumns(newListGrid);
            this.initSelectionModel(newListGrid);
            newListGrid.loadPageSizePreferences();
            newListGrid.createPageSizesListBox(5, 20, 5);
            if (this.column.childNodes.length == 1.0) {
                this.column.removeChild(this.column.firstChild);
            }
            new Elemental2DomUtil().appendWidgetToElement((HTMLElement)this.column, (Widget)newListGrid);
            this.listTable = newListGrid;
            readyCallback.accept(this.listTable);
        })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public ListTable<T> getListGrid() {
        return this.listTable;
    }

    public abstract void initColumns(ListTable<T> var1);

    public abstract void initSelectionModel(ListTable<T> var1);

    public abstract List<String> getInitColumns();

    public abstract List<String> getBannedColumns();

    @Inject
    public void setUserPreferencesService(Caller<UserPreferencesService> userPreferencesService) {
        this.userPreferencesService = userPreferencesService;
    }

    public Column<T, String> createTextColumn(String columnId, final Function<T, String> valueFunction) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return (String)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    public Column<T, Number> createNumberColumn(String columnId, final Function<T, Number> valueFunction) {
        Column column = new Column<T, Number>((Cell)new NumberCell()){

            public Number getValue(T domain) {
                return (Number)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    protected ColumnMeta<T> initChecksColumn(final ListTable<T> extendedPagedTable) {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column checkColumn = new Column<T, Boolean>((Cell)checkboxCell){

            public Boolean getValue(T item) {
                return extendedPagedTable.isItemSelected(item);
            }
        };
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName(COL_ID_SELECT);
        checkColumn.setCellStyleNames("kie-datatable-select");
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                return extendedPagedTable.isAllItemsSelected();
            }
        };
        selectPageHeader.setUpdater(value -> {
            if (value.booleanValue()) {
                extendedPagedTable.selectAllItems();
            } else {
                extendedPagedTable.deselectAllItems();
            }
            this.controlBulkOperations(extendedPagedTable);
        });
        selectPageHeader.setHeaderStyleNames("kie-datatable-select");
        checkColumn.setFieldUpdater((index, model, value) -> {
            extendedPagedTable.setItemSelection((T)model, (Boolean)value);
            this.controlBulkOperations(extendedPagedTable);
        });
        ColumnMeta checkColMeta = new ColumnMeta(checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    protected abstract List<ConditionalAction<T>> getConditionalActions();

    protected ColumnMeta<T> initActionsColumn() {
        ConditionalKebabActionCell cell = (ConditionalKebabActionCell)((Object)this.conditionalKebabActionCell.get());
        cell.setActions(this.getConditionalActions());
        Column actionsColumn = new Column<T, T>((Cell)cell){

            public T getValue(T object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        actionsColumn.setCellStyleNames("kie-table-view-pf-actions text-center");
        TextHeader header = new TextHeader(Constants.INSTANCE.Actions());
        header.setHeaderStyleNames("text-center");
        ColumnMeta actionsColMeta = new ColumnMeta(actionsColumn, "");
        actionsColMeta.setHeader((Header)header);
        return actionsColMeta;
    }

    @Override
    public void setSaveFilterCallback(BiConsumer<String, Consumer<String>> filterNameCallback) {
        this.filters.setSaveFilterCallback(filterNameCallback);
    }

    @Override
    public <T> void addActiveFilter(ActiveFilterItem<T> filter) {
        this.filters.addActiveFilter(filter);
    }

    @Override
    public <T> void removeActiveFilter(ActiveFilterItem<T> filter) {
        this.filters.removeActiveFilter(filter);
    }

    @Override
    public void removeAllActiveFilters() {
        this.filters.removeAllActiveFilters();
    }
}

