/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public class ExtendedPagedTable<T extends GenericSummary>
extends PagedTable<T> {
    private List<Column<T, ?>> ignoreSelectionColumns = new ArrayList();
    private List<T> selectedItems = new ArrayList<T>();
    private Consumer<T> selectionCallback;

    public ExtendedPagedTable(GridGlobalPreferences gridPreferences) {
        super(10, item -> item == null ? null : item.getId(), gridPreferences, true, false, false, false);
        this.dataGrid.addColumnSortHandler((ColumnSortEvent.Handler)new ColumnSortEvent.AsyncHandler((HasData)this.dataGrid));
        this.setSelectionModel((SelectionModel)this.createSelectionModel(), (CellPreviewEvent.Handler)this.createNoActionColumnManager());
    }

    public void setTooltip(int row, int column, String description) {
        ((TableCellElement)this.dataGrid.getRowElement(row).getCells().getItem(column)).setTitle(description);
    }

    public int getKeyboardSelectedColumn() {
        return this.dataGrid.getKeyboardSelectedColumn();
    }

    public int getKeyboardSelectedRow() {
        return this.dataGrid.getKeyboardSelectedRow();
    }

    public int getColumnCount() {
        return this.dataGrid.getColumnCount();
    }

    public void removeColumn(Column<T, ?> col) {
        this.dataGrid.removeColumn(col);
    }

    public void removeColumnMeta(ColumnMeta<T> columnMeta) {
        this.columnPicker.removeColumn(columnMeta);
    }

    public Collection<ColumnMeta<T>> getColumnMetaList() {
        return this.columnPicker.getColumnMetaList();
    }

    public void addSelectionIgnoreColumn(Column<T, ?> column) {
        if (!this.ignoreSelectionColumns.contains(column)) {
            this.ignoreSelectionColumns.add(column);
        }
    }

    public boolean removeSelectionIgnoreColumn(Column<T, ?> column) {
        return this.ignoreSelectionColumns.remove(column);
    }

    public boolean isSelectionIgnoreColumn(int colIx) {
        return colIx >= 0 && this.ignoreSelectionColumns.stream().anyMatch(col -> this.getColumnIndex((Column)col) == colIx);
    }

    public List<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected void setSelectedItems(List<T> selectedItems) {
        this.selectedItems = selectedItems;
    }

    public boolean isItemSelected(T item) {
        return this.selectedItems.contains(item);
    }

    public boolean hasSelectedItems() {
        return StreamSupport.stream(this.getVisibleItems().spliterator(), false).anyMatch(item -> this.isItemSelected(item));
    }

    public void deselectAllItems() {
        for (int i = 0; i < this.getVisibleItemCount(); ++i) {
            GenericSummary item = (GenericSummary)this.getVisibleItem(i);
            if (!this.selectedItems.contains(item)) continue;
            this.updateSelectedColumnRow(i, item, false);
        }
        this.selectedItems.clear();
    }

    public void selectAllItems() {
        for (int i = 0; i < this.getVisibleItemCount(); ++i) {
            GenericSummary item = (GenericSummary)this.getVisibleItem(i);
            if (this.selectedItems.contains(item)) continue;
            this.updateSelectedColumnRow(i, item, true);
            this.selectedItems.add(item);
        }
    }

    public void updateSelectedColumnRow(Integer row, T object, Boolean value) {
        Column column = this.dataGrid.getColumn(0);
        column.getFieldUpdater().update(row.intValue(), object, (Object)value);
        this.dataGrid.redrawRow(row.intValue());
    }

    public boolean isAllItemsSelected() {
        if (this.getVisibleItemCount() == 0) {
            return false;
        }
        return StreamSupport.stream(this.getVisibleItems().spliterator(), false).allMatch(item -> this.isItemSelected(item));
    }

    protected NoSelectionModel<T> createSelectionModel() {
        NoSelectionModel selectionModel = new NoSelectionModel();
        selectionModel.addSelectionChangeHandler(event -> {
            if (this.selectionCallback != null) {
                this.selectionCallback.accept(selectionModel.getLastSelectedObject());
            }
        });
        return selectionModel;
    }

    protected DefaultSelectionEventManager<T> createNoActionColumnManager() {
        final ExtendedPagedTable extendedPagedTable = this;
        return DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<T>(){

            public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.isSelectionIgnoreColumn(event.getColumn())) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
    }

    public void setSelectionCallback(Consumer<T> selectionCallback) {
        this.selectionCallback = selectionCallback;
    }

    public void setItemSelection(T item, Boolean newValue) {
        if (item == null) {
            return;
        }
        if (newValue.booleanValue() == this.isItemSelected(item)) {
            return;
        }
        if (newValue.booleanValue()) {
            this.selectedItems.add(item);
        } else {
            this.selectedItems.remove(item);
        }
        this.dataGrid.redrawHeaders();
    }
}

