/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import elemental2.dom.HTMLElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

public class PrimaryActionMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    private final List<EnabledStateChangeListener> changeListeners = new ArrayList<EnabledStateChangeListener>();
    private Button button = (Button)IOC.getBeanManager().lookupBean(Button.class, new Annotation[0]).newInstance();

    public PrimaryActionMenuBuilder(String label, Command command) {
        this.button.setType(Button.ButtonType.BUTTON);
        this.button.setButtonStyleType(Button.ButtonStyleType.PRIMARY);
        this.setupButton(label, "", "");
        this.button.setClickHandler(() -> command.execute());
    }

    public PrimaryActionMenuBuilder(String label, String icon, String title, Command command, boolean notifyChangeListeners) {
        this.button.setButtonStyleType(Button.ButtonStyleType.LINK);
        this.setupButton(label, icon, title);
        this.button.setClickHandler(() -> {
            command.execute();
            if (notifyChangeListeners) {
                this.notifyListeners(true);
            }
        });
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<HTMLElement>(){

            public HTMLElement build() {
                return PrimaryActionMenuBuilder.this.button.getElement();
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                PrimaryActionMenuBuilder.this.notifyListeners(enabled);
            }

            public void addEnabledStateChangeListener(EnabledStateChangeListener listener) {
                PrimaryActionMenuBuilder.this.addChangeListener(listener);
            }
        };
    }

    private void setupButton(String label, String icon, String title) {
        if (label != null && !label.isEmpty()) {
            this.button.setText(label);
        }
        if (icon != null && !icon.isEmpty()) {
            this.button.addIcon(new String[]{"fa", icon});
        }
        if (title != null && !title.isEmpty()) {
            this.button.getElement().title = title;
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.button.show();
        } else {
            this.button.hide();
        }
    }

    public void addChangeListener(EnabledStateChangeListener listener) {
        this.changeListeners.add(listener);
    }

    private void notifyListeners(boolean enabled) {
        for (EnabledStateChangeListener listener : this.changeListeners) {
            listener.enabledStateChanged(enabled);
        }
    }
}

