/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import java.util.Collections;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.df.client.filter.FilterEditorPopup;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

public abstract class AbstractBasicFiltersPresenterTest {
    @Mock
    BasicFiltersView view;
    @Mock
    FilterEditorPopup filterEditorPopup;
    @Mock
    FilterSettingsManager filterSettingsManager;
    @Spy
    Event<BasicFilterAddEvent> activeFilters = new EventSourceMock();
    @Spy
    Event<BasicFilterRemoveEvent> basicFilterRemoveEvent = new EventSourceMock();
    @Spy
    Event<SavedFilterSelectedEvent> savedFilterSelectedEvent = new EventSourceMock();

    public abstract BasicFiltersPresenter getPresenter();

    public BasicFiltersView getView() {
        return this.view;
    }

    @Before
    public void init() {
        ((Event)Mockito.doNothing().when(this.savedFilterSelectedEvent)).fire(Matchers.any());
        ((Event)Mockito.doNothing().when(this.activeFilters)).fire(Matchers.any());
        ((Event)Mockito.doNothing().when(this.basicFilterRemoveEvent)).fire(Matchers.any());
    }

    @Test
    public void testSaveAdvancedFiltersCallback() {
        ((BasicFiltersView)Mockito.doAnswer(invocation -> {
            Command callback = (Command)invocation.getArguments()[0];
            callback.execute();
            return null;
        }).when((Object)this.view)).setAdvancedFiltersCallback((Command)Matchers.any());
        this.getPresenter().init();
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).setTitle((String)Matchers.any());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Consumer.class);
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).show((FilterSettings)Matchers.any(), (Consumer)captor.capture());
        FilterSettings filterSettings = new FilterSettings();
        ((Consumer)captor.getValue()).accept(filterSettings);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).saveFilterIntoPreferences((FilterSettings)Matchers.eq((Object)filterSettings), (Consumer)captor.capture());
        ((Consumer)captor.getValue()).accept(true);
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).hide();
        ((Event)Mockito.verify(this.savedFilterSelectedEvent)).fire(Matchers.any());
    }

    @Test
    public void testSaveInvalidAdvancedFiltersCallback() {
        ((BasicFiltersView)Mockito.doAnswer(invocation -> {
            Command callback = (Command)invocation.getArguments()[0];
            callback.execute();
            return null;
        }).when((Object)this.view)).setAdvancedFiltersCallback((Command)Matchers.any());
        this.getPresenter().init();
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).setTitle((String)Matchers.any());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Consumer.class);
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).show((FilterSettings)Matchers.any(), (Consumer)captor.capture());
        FilterSettings filterSettings = new FilterSettings();
        ((Consumer)captor.getValue()).accept(filterSettings);
        ((FilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).saveFilterIntoPreferences((FilterSettings)Matchers.eq((Object)filterSettings), (Consumer)captor.capture());
        ((Consumer)captor.getValue()).accept(false);
        ((FilterEditorPopup)Mockito.verify((Object)this.filterEditorPopup)).setTableNameError((String)Matchers.any());
    }

    @Test
    public void testSearchFilterListEmpty() {
        this.getPresenter().addSearchFilterList("columnId", new ActiveFilterItem(null, null, null, Collections.emptyList(), null));
        ((Event)Mockito.verify(this.basicFilterRemoveEvent)).fire(Matchers.any());
    }

    @Test
    public void testSearchFilterList() {
        this.getPresenter().addSearchFilterList("columnId", new ActiveFilterItem(null, null, null, Collections.singletonList("value"), null));
        ((Event)Mockito.verify(this.activeFilters)).fire(Matchers.any());
    }

    public abstract void testLoadFilters();
}

