/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import com.google.common.base.Strings;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.events.DataSetReadyEvent;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.views.pfly.widgets.ErrorPopup;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
public class DataSetAwareSelect {
    @Inject
    protected DataSetClientServices dataSetClientServices;
    @Inject
    protected ErrorPopup errorPopup;
    @Inject
    protected Select select;
    private String valueColumnId;
    private String textColumnId;
    private DataSetLookup dataSetLookup;

    @PostConstruct
    public void init() {
        this.select.disable();
    }

    public void setDataSetLookup(DataSetLookup dataSetLookup) {
        this.dataSetLookup = dataSetLookup;
    }

    public void setTextColumnId(String textColumnId) {
        this.textColumnId = textColumnId;
    }

    public void setValueColumnId(String valueColumnId) {
        this.valueColumnId = valueColumnId;
    }

    public void onDataSetReady(@Observes DataSetReadyEvent event) {
        FilterSettings filterSettings = event.getFilterSettings();
        if (filterSettings.getServerTemplateId() == null || filterSettings.getServerTemplateId().isEmpty()) {
            this.removeOptions();
            return;
        }
        this.select.getElement().getParentElement().getElementsByTagName("button").item(0).addEventListener("click", e -> {
            if (this.dataSetLookup.getDataSetUUID().equals(event.getDataSetUUID())) {
                try {
                    this.dataSetClientServices.lookupDataSet(ConsoleDataSetLookup.fromInstance((DataSetLookup)this.dataSetLookup, (String)filterSettings.getServerTemplateId()), new DataSetReadyCallback(){

                        public void callback(DataSet dataSet) {
                            DataSetAwareSelect.this.select.refresh(s -> {
                                s.removeAllOptions();
                                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                    String text = (String)dataSet.getValueAt(i, DataSetAwareSelect.this.textColumnId);
                                    String value = (String)dataSet.getValueAt(i, DataSetAwareSelect.this.valueColumnId);
                                    if (Strings.isNullOrEmpty((String)text) || Strings.isNullOrEmpty((String)value)) continue;
                                    s.addOption(text, value);
                                }
                                if (s.getOptions().getLength() > 0) {
                                    s.enable();
                                } else {
                                    s.disable();
                                }
                            });
                        }

                        public void notFound() {
                            DataSetAwareSelect.this.removeOptions();
                            DataSetAwareSelect.this.errorPopup.showError(Constants.INSTANCE.DataSetNotFound(DataSetAwareSelect.this.dataSetLookup.getDataSetUUID()));
                        }

                        public boolean onError(ClientRuntimeError error) {
                            DataSetAwareSelect.this.removeOptions();
                            DataSetAwareSelect.this.errorPopup.showError(Constants.INSTANCE.DataSetError(DataSetAwareSelect.this.dataSetLookup.getDataSetUUID(), error.getMessage()));
                            return false;
                        }
                    });
                }
                catch (Exception ex) {
                    new DefaultWorkbenchErrorCallback().error((Throwable)ex);
                }
            }
        }, false);
        this.select.enable();
    }

    protected void removeOptions() {
        this.select.refresh(s -> {
            s.removeAllOptions();
            s.disable();
        });
    }

    public Select getSelect() {
        return this.select;
    }
}

