/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import com.google.gwt.user.client.DOM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.dashbuilder.dataset.DataSetLookup;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.Form;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.OptionsCollection;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.dataset.DataSetAwareSelect;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.common.client.list.DatePickerRange;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateRange;
import org.uberfire.client.views.pfly.widgets.DateRangePicker;
import org.uberfire.client.views.pfly.widgets.DateRangePickerOptions;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated(stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class BasicFiltersViewImpl
implements BasicFiltersView,
IsElement {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="content")
    Div content;
    @Inject
    @DataField(value="filter-list")
    Div filterList;
    @Inject
    @DataField(value="refine")
    @Named(value="h5")
    Heading refine;
    @Inject
    @DataField(value="refine-options")
    Select refineSelect;
    @Inject
    @DataField(value="filters-input")
    Div filtersInput;
    @Inject
    @DataField(value="filters-input-help")
    Button filtersInputHelp;
    @Inject
    @DataField(value="refine-apply")
    Button refineApply;
    @Inject
    @DataField(value="form")
    Form form;
    @Inject
    private JQueryProducer.JQuery<Popover> jQueryPopover;
    @Inject
    private ManagedInstance<Select> selectProvider;
    @Inject
    private ManagedInstance<DataSetAwareSelect> dataSetSelectProvider;
    @Inject
    private ManagedInstance<DateRangePicker> dateRangePickerProvider;
    private Map<String, List<Input>> selectInputs = new HashMap<String, List<Input>>();

    @PostConstruct
    public void init() {
        this.refine.setTextContent(this.constants.FilterBy());
        this.filtersInputHelp.setAttribute("data-content", this.getInputStringHelpHtml());
        ((Popover)this.jQueryPopover.wrap((Element)this.filtersInputHelp)).popover();
        this.refineSelect.getElement().addEventListener("change", e -> this.setInputCurrentFilter(this.refineSelect.getValue()), false);
        this.refineApply.setTextContent(this.constants.Apply());
    }

    private String getInputStringHelpHtml() {
        return "<p>" + this.constants.AllowedWildcardsForStrings() + "</p>\n <ul>\n   <li><code>_</code> - " + this.constants.ASubstituteForASingleCharacter() + "</li>\n   <li><code>%</code> - " + this.constants.ASubstituteForZeroOrMoreCharacters() + "</li>\n </ul>\n";
    }

    public HTMLElement getElement() {
        return this.content;
    }

    @Override
    public void addTextFilter(String label, String placeholder, Consumer<ActiveFilterItem<String>> callback) {
        this.createFilterOption(label);
        this.createInput(label, placeholder, this.refineSelect.getOptions().getLength() > 1, input -> input.setType("text"), v -> v, callback);
    }

    @Override
    public void addNumericFilter(String label, String placeholder, Consumer<ActiveFilterItem<Integer>> callback) {
        this.createFilterOption(label);
        this.createInput(label, placeholder, this.refineSelect.getOptions().getLength() > 1, input -> {
            input.setType("number");
            input.setAttribute("min", "0");
            input.addEventListener("keypress", this.getNumericInputListener(), false);
        }, v -> Integer.valueOf(v), callback);
    }

    protected EventListener<KeyboardEvent> getNumericInputListener() {
        return e -> {
            int keyCode = e.getKeyCode();
            if (keyCode <= 0) {
                keyCode = e.getWhich();
            }
            if (!(keyCode >= 96 && keyCode <= 105 || keyCode >= 48 && keyCode <= 57 || keyCode == 8 || keyCode == 37 || keyCode == 39)) {
                e.preventDefault();
            }
        };
    }

    @Override
    public void addDataSetSelectFilter(String label, DataSetLookup lookup, String textColumnId, String valueColumnId, Consumer<ActiveFilterItem<String>> callback) {
        DataSetAwareSelect select = (DataSetAwareSelect)this.dataSetSelectProvider.get();
        select.setDataSetLookup(lookup);
        select.setTextColumnId(textColumnId);
        select.setValueColumnId(valueColumnId);
        this.setupSelect(label, select.getSelect(), callback);
    }

    @Override
    public void addDateRangeFilter(String label, String placeholder, Boolean useMaxDate, Consumer<ActiveFilterItem<DateRange>> callback) {
        DateRangePicker dateRangePicker = (DateRangePicker)this.dateRangePickerProvider.get();
        dateRangePicker.getElement().setReadOnly(true);
        dateRangePicker.getElement().setAttribute("placeholder", placeholder);
        DOMUtil.addCSSClass((HTMLElement)dateRangePicker.getElement(), (String)"form-control");
        DOMUtil.addCSSClass((HTMLElement)dateRangePicker.getElement(), (String)"bootstrap-datepicker");
        DateRangePickerOptions options = this.getDateRangePickerOptions(useMaxDate);
        dateRangePicker.setup(options, null);
        dateRangePicker.addApplyListener((e, p) -> {
            Optional<DatePickerRange> datePickerRange = DatePickerRange.getDatePickerRangeFromLabel(p.getChosenLabel());
            this.onDateRangeValueChange(label, datePickerRange.isPresent() ? datePickerRange.get().getLabel() : this.constants.Custom(), datePickerRange.isPresent() ? datePickerRange.get().getStartDate() : p.getStartDate(), datePickerRange.isPresent() ? datePickerRange.get().getEndDate() : p.getEndDate(), callback);
        });
        this.appendHorizontalRule();
        this.appendSectionTitle(label);
        Div div = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)div, (String)"input-group");
        DOMUtil.addCSSClass((HTMLElement)div, (String)"date");
        Span spanGroup = (Span)Window.getDocument().createElement("span");
        DOMUtil.addCSSClass((HTMLElement)spanGroup, (String)"input-group-addon");
        Span spanIcon = (Span)Window.getDocument().createElement("span");
        DOMUtil.addCSSClass((HTMLElement)spanIcon, (String)"fa");
        DOMUtil.addCSSClass((HTMLElement)spanIcon, (String)"fa-calendar");
        spanGroup.appendChild((Node)spanIcon);
        div.appendChild((Node)dateRangePicker.getElement());
        div.appendChild((Node)spanGroup);
        this.appendFormGroup((HTMLElement)div);
    }

    protected DateRangePickerOptions getDateRangePickerOptions(Boolean useMaxDate) {
        DateRangePickerOptions options = DateRangePickerOptions.create();
        options.setAutoUpdateInput(Boolean.valueOf(false));
        options.setAutoApply(Boolean.valueOf(true));
        options.setTimePicker(Boolean.valueOf(true));
        options.setDrops("up");
        options.setTimePickerIncrement(30);
        if (useMaxDate.booleanValue()) {
            options.setMaxDate(Moment.Builder.moment().endOf("day"));
        }
        for (DatePickerRange range : DatePickerRange.values()) {
            options.addRange(range.getLabel(), range.getStartDate(), range.getEndDate().endOf("day"));
        }
        return options;
    }

    protected void onDateRangeValueChange(String label, String selectedLabel, Moment fromDate, Moment toDate, Consumer<ActiveFilterItem<DateRange>> callback) {
        DateRange dateRange = new DateRange(fromDate.milliseconds(0).asDate(), toDate.milliseconds(0).asDate());
        String hint = this.constants.From() + ": " + fromDate.format("lll") + "<br>" + this.constants.To() + ": " + toDate.format("lll");
        this.addActiveFilter(label, selectedLabel, hint, dateRange, callback);
    }

    @Override
    public void addSelectFilter(String label, Map<String, String> options, Consumer<ActiveFilterItem<String>> callback) {
        Select select = (Select)this.selectProvider.get();
        options.forEach((k, v) -> select.addOption(v, k));
        this.setupSelect(label, select, callback);
    }

    @Override
    public void clearAllSelectFilter() {
        this.selectInputs.values().forEach(values -> values.forEach(i -> {
            if (i.getChecked()) {
                i.setChecked(false);
            }
        }));
    }

    @Override
    public void checkSelectFilter(String label, String value) {
        this.selectInputs.computeIfPresent(label, (key, values) -> {
            values.forEach(i -> {
                if (i.getValue().equals(value) && !i.getChecked()) {
                    i.setChecked(true);
                }
            });
            return values;
        });
    }

    @Override
    public void clearSelectFilter(String label) {
        this.selectInputs.computeIfPresent(label, (key, values) -> {
            values.forEach(i -> {
                if (i.getChecked()) {
                    i.setChecked(false);
                }
            });
            return values;
        });
    }

    @Override
    public void addMultiSelectFilter(String label, Map<String, String> options, Consumer<ActiveFilterItem<List<String>>> callback) {
        HTMLElement hr = Window.getDocument().createElement("hr");
        DOMUtil.addCSSClass((HTMLElement)hr, (String)"kie-dock__divider");
        DOMUtil.addCSSClass((HTMLElement)hr, (String)"kie-dock__divider_collapse");
        this.form.insertBefore((Node)hr, this.form.getFirstChild());
        Div group = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)group, (String)"panel-group");
        DOMUtil.addCSSClass((HTMLElement)group, (String)"kie-dock__panel-group");
        this.form.insertBefore((Node)group, this.form.getFirstChild());
        Div heading = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)heading, (String)"panel-heading");
        DOMUtil.addCSSClass((HTMLElement)heading, (String)"kie-dock__panel-heading");
        group.appendChild((Node)heading);
        Div title = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)title, (String)"panel-title");
        DOMUtil.addCSSClass((HTMLElement)title, (String)"kie-dock__heading--section");
        heading.appendChild((Node)title);
        Anchor anchorTitle = (Anchor)Window.getDocument().createElement("a");
        anchorTitle.setAttribute("data-toggle", "collapse");
        String divId = DOM.createUniqueId();
        anchorTitle.setAttribute("data-target", "#" + divId);
        anchorTitle.setTextContent(label);
        title.appendChild((Node)anchorTitle);
        Div content = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)content, (String)"panel-collapse");
        DOMUtil.addCSSClass((HTMLElement)content, (String)"collapse");
        DOMUtil.addCSSClass((HTMLElement)content, (String)"in");
        content.setId(divId);
        group.appendChild((Node)content);
        Div divPanel = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)divPanel, (String)"panel-body");
        DOMUtil.addCSSClass((HTMLElement)divPanel, (String)"kie-dock__panel-body");
        content.appendChild((Node)divPanel);
        Div div = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)div, (String)"form-group");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            Label labelElement = (Label)Window.getDocument().createElement("label");
            Input input = (Input)Window.getDocument().createElement("input");
            input.setType("checkbox");
            input.setValue(entry.getKey());
            input.setAttribute("data-label", entry.getValue());
            input.addEventListener("change", e -> {
                ArrayList values = new ArrayList();
                ArrayList labels = new ArrayList();
                this.selectInputs.get(label).stream().filter(i -> i.getChecked()).forEach(i -> {
                    values.add(i.getValue());
                    labels.add(i.getAttribute("data-label"));
                });
                this.addActiveFilter(label, String.join((CharSequence)", ", labels), null, values, callback);
            }, false);
            this.selectInputs.computeIfAbsent(label, key -> new ArrayList());
            this.selectInputs.get(label).add(input);
            labelElement.appendChild((Node)input);
            labelElement.appendChild((Node)Window.getDocument().createTextNode(entry.getValue()));
            Div checkBoxDiv = (Div)Window.getDocument().createElement("div");
            DOMUtil.addCSSClass((HTMLElement)checkBoxDiv, (String)"checkbox");
            checkBoxDiv.appendChild((Node)labelElement);
            div.appendChild((Node)checkBoxDiv);
        }
        divPanel.appendChild((Node)div);
    }

    private void setupSelect(String label, Select select, Consumer<ActiveFilterItem<String>> callback) {
        this.appendHorizontalRule();
        this.appendSectionTitle(label);
        select.setTitle(this.constants.Select());
        select.setWidth("100%");
        DOMUtil.addCSSClass((HTMLElement)select.getElement(), (String)"selectpicker");
        DOMUtil.addCSSClass((HTMLElement)select.getElement(), (String)"form-control");
        select.getElement().addEventListener("change", event -> {
            if (!select.getValue().isEmpty()) {
                OptionsCollection options = select.getOptions();
                for (int i = 0; i < options.getLength(); ++i) {
                    Option item = (Option)options.item(i);
                    if (!item.getSelected()) continue;
                    this.addActiveFilter(label, item.getText(), null, select.getValue(), callback);
                    select.setValue("");
                    break;
                }
            }
        }, false);
        this.appendFormGroup(select.getElement());
        select.refresh();
    }

    private void appendFormGroup(HTMLElement element) {
        Div div = (Div)Window.getDocument().createElement("div");
        DOMUtil.addCSSClass((HTMLElement)div, (String)"form-group");
        div.appendChild((Node)element);
        this.filterList.appendChild((Node)div);
    }

    private void appendHorizontalRule() {
        HTMLElement hr = Window.getDocument().createElement("hr");
        DOMUtil.addCSSClass((HTMLElement)hr, (String)"kie-dock__divider");
        this.filterList.appendChild((Node)hr);
    }

    private void appendSectionTitle(String title) {
        Heading heading = (Heading)Window.getDocument().createElement("h5");
        heading.setTextContent(title);
        DOMUtil.addCSSClass((HTMLElement)heading, (String)"kie-dock__heading--section");
        this.filterList.appendChild((Node)heading);
    }

    private <T> void createInput(String label, String placeholder, Boolean hidden, Consumer<Input> customizeCallback, Function<String, T> valueMapper, Consumer<ActiveFilterItem<T>> callback) {
        Input input = (Input)Window.getDocument().createElement("input");
        customizeCallback.accept(input);
        input.setAttribute("placeholder", placeholder);
        input.setAttribute("data-filter", label);
        DOMUtil.addCSSClass((HTMLElement)input, (String)"form-control");
        DOMUtil.addCSSClass((HTMLElement)input, (String)"filter-control");
        if (hidden.booleanValue()) {
            DOMUtil.addCSSClass((HTMLElement)input, (String)"hidden");
        }
        input.setOnkeypress(e -> {
            if (!(e != null && e.getKeyCode() != 13 || input.getValue().isEmpty())) {
                this.addActiveFilter(label, input.getValue(), null, valueMapper.apply(input.getValue()), callback);
                input.setValue("");
            }
        });
        this.filtersInput.insertBefore((Node)input, this.filtersInput.getFirstChild());
    }

    private void createFilterOption(String label) {
        this.refineSelect.addOption(label);
        this.refineSelect.refresh();
    }

    private void setInputCurrentFilter(String label) {
        for (Element child : DOMUtil.elementIterable((NodeList)this.filtersInput.getChildNodes())) {
            if (!child.getTagName().equals("INPUT")) continue;
            if (label.equals(child.getAttribute("data-filter"))) {
                DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
                continue;
            }
            DOMUtil.addCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
        }
    }

    @EventHandler(value={"refine-apply"})
    public void onApplyClick(@ForEvent(value={"click"}) Event e) {
        for (Element child : DOMUtil.elementIterable((NodeList)this.filtersInput.getChildNodes())) {
            Input input;
            if (!child.getTagName().equals("INPUT") || (input = (Input)child).getClassList().contains("hidden")) continue;
            input.getOnkeypress().call(null);
            break;
        }
    }

    protected <T> void addActiveFilter(String labelKey, String labelValue, String hint, T value, Consumer<ActiveFilterItem<T>> callback) {
        if (callback != null) {
            callback.accept(new ActiveFilterItem<T>(labelKey, labelKey + ": " + labelValue, hint, value, null));
        }
    }

    protected Map<String, List<Input>> getSelectInputs() {
        return this.selectInputs;
    }
}

