/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.backend;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.dashboard.renderer.backend.DataSetDefsBootstrap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DataSetDefsDatabaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetDefsDatabaseTest.class);
    EntityManagerFactory emf;
    Connection conn;
    Database database;
    @Mock
    DataSetDefRegistry defRegistry;
    @InjectMocks
    DataSetDefsBootstrap dataSetDefs;

    public DataSetDefsDatabaseTest(Database database) {
        this.database = database;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({Database.H2}, {Database.H2_DB2}, {Database.H2_MSSQLServer}, {Database.H2_MySQL}, {Database.H2_Oracle}, {Database.H2_PostgreSQL}, {Database.HSQLDB});
    }

    @Before
    public void setup() throws SQLException {
        LOGGER.info("Testing DataSet SQL with DB: {}", (Object)this.database);
        MockitoAnnotations.initMocks((Object)this);
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.domain", (Map)this.database.properties());
        this.conn = DriverManager.getConnection(this.database.url);
    }

    @After
    public void clean() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
    }

    @Test
    public void testDataSetSQL() {
        this.dataSetDefs.registerDataSetDefinitions();
        ArgumentCaptor dataSetDef = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.defRegistry, (VerificationMode)Mockito.times((int)2))).registerDataSetDef((DataSetDef)dataSetDef.capture());
        for (SQLDataSetDef dataSet : dataSetDef.getAllValues()) {
            if (dataSet.getDbSQL() == null) continue;
            try {
                LOGGER.info("Testing SQL DataSet: {}", (Object)dataSet.getName());
                LOGGER.info("SQL: {}", (Object)dataSet.getDbSQL());
                PreparedStatement ps = this.conn.prepareStatement(dataSet.getDbSQL());
                ResultSet rs = ps.executeQuery();
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int i = 0; i < dataSet.getColumns().size(); ++i) {
                    Assert.assertTrue((String)"select column name don't match", (boolean)((DataColumnDef)dataSet.getColumns().get(i)).getId().equalsIgnoreCase(resultSetMetaData.getColumnLabel(i + 1)));
                }
                ps.close();
                String countSQL = "SELECT COUNT(*) FROM (SELECT * FROM (" + dataSet.getDbSQL() + ") )";
                this.conn.prepareStatement(countSQL).executeQuery();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to execute query for DataSet {} on DB {}", new Object[]{dataSet.getName(), this.database.name(), ex});
                Assert.fail((String)ex.getMessage());
            }
        }
    }

    public static enum Database {
        HSQLDB("org.hibernate.dialect.HSQLDialect", "jdbc:hsqldb:mem:datasetdb;sql.enforce_refs=true;shutdown=true", "org.hsqldb.jdbc.JDBCDriver"),
        H2("org.hibernate.dialect.H2Dialect", "jdbc:h2:mem:datasetdb", "org.h2.Driver"),
        H2_DB2("org.hibernate.dialect.DB2Dialect", "jdbc:h2:mem:datasetdbdb2;MODE=DB2", "org.h2.Driver"),
        H2_Oracle("org.hibernate.dialect.Oracle10gDialect", "jdbc:h2:mem:datasetdboracle;MODE=Oracle", "org.h2.Driver"),
        H2_PostgreSQL("org.hibernate.dialect.PostgreSQL82Dialect", "jdbc:h2:mem:datasetdbpostgresql;MODE=PostgreSQL", "org.h2.Driver"),
        H2_MySQL("org.hibernate.dialect.MySQLDialect", "jdbc:h2:mem:datasetdbmysql;MODE=MySQL", "org.h2.Driver"),
        H2_MSSQLServer("org.hibernate.dialect.SQLServerDialect", "jdbc:h2:mem:datasetdbmssql;MODE=MSSQLServer", "org.h2.Driver");

        private String dialect;
        private String url;
        private String driver;

        private Database(String dialect, String url, String driver) {
            this.dialect = dialect;
            this.url = url;
            this.driver = driver;
        }

        public Properties properties() {
            Properties p = new Properties();
            p.put("hibernate.dialect", this.dialect);
            p.put("javax.persistence.jdbc.driver", this.driver);
            p.put("javax.persistence.jdbc.url", this.url);
            return p;
        }
    }
}

