/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.backend;

import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.dashboard.renderer.backend.DataSetDefsBootstrap;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DataSetDefRegistry dataSetRegistry;
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;

    @Test
    public void testProcessInstancesDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("processesMonitoring").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"processesMonitoring", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-processesMonitoring", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)10L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testHumanTasksDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("tasksMonitoring").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"tasksMonitoring", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-tasksMonitoring", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)11L, (long)dataSetDef.getColumns().size());
    }
}

