/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DashboardColumnsTest {
    Set<String> columnNamesProcessInstanceLog = new HashSet<String>();
    Set<String> columnNamesBAMTaskSummary = new HashSet<String>();

    @Before
    public void setUp() {
        Column columnAnnotation;
        String columnName;
        Field[] fields;
        for (Field field : fields = ProcessInstanceLog.class.getDeclaredFields()) {
            columnName = field.getName();
            columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation != null && columnAnnotation.name() != null && columnAnnotation.name().length() > 0) {
                columnName = columnAnnotation.name();
            }
            this.columnNamesProcessInstanceLog.add(columnName);
        }
        for (Field field : fields = BAMTaskSummaryImpl.class.getDeclaredFields()) {
            columnName = field.getName();
            columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation != null && columnAnnotation.name() != null && columnAnnotation.name().length() > 0) {
                columnName = columnAnnotation.name();
            }
            this.columnNamesBAMTaskSummary.add(columnName);
        }
    }

    @Test
    public void testProcessMonitoringColumns() {
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("processId"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("duration"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("end_date"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("externalId"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("processInstanceId"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("processName"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("start_date"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("status"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("user_identity"));
        Assert.assertTrue((boolean)this.columnNamesProcessInstanceLog.contains("processVersion"));
    }

    @Test
    public void testTaskMonitoringColumns() {
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("createdDate"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("userId"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("duration"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("endDate"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("taskId"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("taskName"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("userId"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("startDate"));
        Assert.assertTrue((boolean)this.columnNamesBAMTaskSummary.contains("status"));
    }
}

