/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.dashboard.renderer.client.panel.formatter.DurationFormatter;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardI18n;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

public abstract class AbstractDashboard {
    protected DataSetClientServices dataSetClientServices;
    protected PlaceManager placeManager;
    protected DashboardI18n i18n;
    protected MetricDisplayer selectedMetric = null;
    protected String selectedProcess = null;
    protected ProcessBreadCrumb processBreadCrumb;
    protected DisplayerLocator displayerLocator;
    protected DisplayerCoordinator displayerCoordinator;
    protected ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;

    public AbstractDashboard(DataSetClientServices dataSetClientServices, PlaceManager placeManager, DashboardI18n i18n, ProcessBreadCrumb processBreadCrumb, DisplayerLocator displayerLocator, DisplayerCoordinator displayerCoordinator, ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        this.dataSetClientServices = dataSetClientServices;
        this.placeManager = placeManager;
        this.i18n = i18n;
        this.processBreadCrumb = processBreadCrumb;
        this.displayerLocator = displayerLocator;
        this.displayerCoordinator = displayerCoordinator;
        this.serverTemplateSelectorMenuBuilder = serverTemplateSelectorMenuBuilder;
    }

    public MetricDisplayer createMetricDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        MetricDisplayer metricDisplayer = (MetricDisplayer)this.displayerLocator.lookupDisplayer(settings);
        metricDisplayer.setDisplayerSettings(settings);
        metricDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        return metricDisplayer;
    }

    private DataSetLookup getDataSetLookup(DisplayerSettings settings) {
        return ConsoleDataSetLookup.fromInstance((DataSetLookup)settings.getDataSetLookup(), (String)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    public TableDisplayer createTableDisplayer(DisplayerSettings settings, String columnId, DurationFormatter durationFormatter) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        final TableDisplayer tableDisplayer = (TableDisplayer)this.displayerLocator.lookupDisplayer(settings);
        tableDisplayer.setDisplayerSettings(settings);
        tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        tableDisplayer.addFormatter(columnId, (ValueFormatter)durationFormatter);
        tableDisplayer.addOnCellSelectedCommand(new Command(){

            public void execute() {
                AbstractDashboard.this.tableCellSelected(tableDisplayer.getSelectedCellColumn(), tableDisplayer.getSelectedCellRow());
            }
        });
        return tableDisplayer;
    }

    public MetricDisplayer getSelectedMetric() {
        return this.selectedMetric;
    }

    public abstract View getView();

    public void resetCurrentMetric() {
        this.selectedMetric = null;
        this.updateHeaderText();
    }

    public abstract void tableCellSelected(String var1, int var2);

    public void changeCurrentMetric(MetricDisplayer metric) {
        if (metric.isFilterOn()) {
            if (this.selectedMetric != null && this.selectedMetric != metric) {
                MetricDisplayer metricToReset = this.selectedMetric;
                metricToReset.filterReset();
                metricToReset.redraw();
            }
            this.selectedMetric = metric;
            this.updateHeaderText();
        } else {
            this.selectedMetric = null;
            this.updateHeaderText();
        }
    }

    public abstract void updateHeaderText();

    public Widget asWidget() {
        return this.getView().asWidget();
    }

    public abstract void resetProcessBreadcrumb();

    public ProcessBreadCrumb getProcessBreadCrumb() {
        return this.processBreadCrumb;
    }

    public String getSelectedProcess() {
        return this.selectedProcess;
    }

    public AbstractDisplayer createDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(settings);
        displayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        return displayer;
    }

    public void changeCurrentProcess(String name) {
        this.selectedProcess = name;
        this.updateHeaderText();
        this.getView().showBreadCrumb(name);
    }

    public void resetCurrentProcess() {
        this.selectedProcess = null;
        this.updateHeaderText();
        this.getView().hideBreadCrumb();
    }

    public static interface View
    extends IsWidget {
        public void showBreadCrumb(String var1);

        public void hideBreadCrumb();

        public void setHeaderText(String var1);

        public void showLoading();

        public void hideLoading();

        public void showDashboard();

        public void showInstances();

        public DashboardI18n getI18nService();
    }
}

