/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.dataset.editor.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collection;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.dashboard.dataset.editor.impl.RemoteDataSetDefAttributesEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RemoteDataSetDefAttributesEditorTest {
    @Mock
    DropDownEditor queryTarget;
    @Mock
    DropDownEditor serverTemplates;
    @Mock
    ValueBoxEditor<String> dataSource;
    @Mock
    ValueBoxEditor<String> dbSQL;
    @Mock
    SpecManagementService specManagementService;
    @Mock
    RemoteDataSetDefAttributesEditor.View view;
    Caller<SpecManagementService> specManagementServiceCaller;
    RemoteDataSetDefAttributesEditor presenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Arrays.asList(new ServerTemplate("", ""))));
        this.specManagementServiceCaller = new CallerMock((Object)this.specManagementService);
        this.presenter = new RemoteDataSetDefAttributesEditor(this.queryTarget, this.serverTemplates, this.dataSource, this.dbSQL, this.view, this.specManagementServiceCaller);
        Mockito.when((Object)this.serverTemplates.newEntry(Matchers.anyString(), Matchers.anyString())).thenReturn(Mockito.mock(DropDownEditor.Entry.class));
        Mockito.when((Object)this.queryTarget.newEntry(Matchers.anyString(), Matchers.anyString())).thenReturn(Mockito.mock(DropDownEditor.Entry.class));
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((RemoteDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((RemoteDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((DropDownEditor.View)Matchers.any(), (DropDownEditor.View)Matchers.any(), (ValueBoxEditor.View)Matchers.any(), (ValueBoxEditor.View)Matchers.any());
        ((ValueBoxEditor)Mockito.verify(this.dataSource, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownEditor)Mockito.verify((Object)this.queryTarget, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownEditor)Mockito.verify((Object)this.serverTemplates, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((DropDownEditor)Mockito.verify((Object)this.queryTarget)).setEntries((Collection)Matchers.any());
        ((DropDownEditor)Mockito.verify((Object)this.serverTemplates)).setSelectHint(Matchers.anyString());
    }

    @Test
    public void testDataSource() {
        Assert.assertEquals(this.dataSource, (Object)this.presenter.dataSource());
    }

    @Test
    public void testQueryTarget() {
        Assert.assertEquals((Object)this.queryTarget, (Object)this.presenter.queryTarget());
    }

    @Test
    public void testServerTemplate() {
        Assert.assertEquals((Object)this.serverTemplates, (Object)this.presenter.serverTemplateId());
    }

    @Test
    public void testDbSQL() {
        Assert.assertEquals(this.dbSQL, (Object)this.presenter.dbSQL());
    }
}

