/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel.formatter;

import java.util.Date;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.displayer.client.formatter.AbstractValueFormatter;

public class DurationFormatter
extends AbstractValueFormatter {
    protected String startDateColumn = null;
    protected String endDateColumn = null;

    public DurationFormatter(String startDateColumn, String endDateColumn) {
        this.startDateColumn = startDateColumn;
        this.endDateColumn = endDateColumn;
    }

    public String formatValue(DataSet dataSet, int row, int column) {
        Date end = (Date)dataSet.getValueAt(row, this.endDateColumn);
        if (end == null) {
            end = new Date();
        }
        Date start = (Date)dataSet.getValueAt(row, this.startDateColumn);
        return this.formatValue(end.getTime() - start.getTime());
    }

    public String formatValue(Object value) {
        if (value == null) {
            return "0s";
        }
        long milliseconds = ((Number)value).longValue();
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        days %= 7L;
        StringBuilder buf = new StringBuilder();
        if (weeks > 0L) {
            buf.append(weeks).append(" weeks ");
        }
        if (days > 0L) {
            buf.append(days).append("d ");
        }
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (minutes > 0L) {
            buf.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            buf.append(seconds).append("s");
        }
        if (buf.length() == 0) {
            return "0s";
        }
        return buf.toString();
    }
}

